//===========================================================================
// @(#) $DwmPath: dwm/mcplex/mcrover/tags/mcrover-0.1.13/classes/src/DwmMcroverZpoolAlert.cc 11886 $
// @(#) $Id: DwmMcroverZpoolAlert.cc 11886 2021-04-07 05:16:39Z dwm $
//===========================================================================
//  Copyright (c) Daniel W. McRobb 2020
//  All rights reserved.
//
//  Redistribution and use in source and binary forms, with or without
//  modification, are permitted provided that the following conditions
//  are met:
//
//  1. Redistributions of source code must retain the above copyright
//     notice, this list of conditions and the following disclaimer.
//  2. Redistributions in binary form must reproduce the above copyright
//     notice, this list of conditions and the following disclaimer in the
//     documentation and/or other materials provided with the distribution.
//  3. The names of the authors and copyright holders may not be used to
//     endorse or promote products derived from this software without
//     specific prior written permission.
//
//  IN NO EVENT SHALL DANIEL W. MCROBB BE LIABLE TO ANY PARTY FOR
//  DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES,
//  INCLUDING LOST PROFITS, ARISING OUT OF THE USE OF THIS SOFTWARE,
//  EVEN IF DANIEL W. MCROBB HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH
//  DAMAGE.
//
//  THE SOFTWARE PROVIDED HEREIN IS ON AN "AS IS" BASIS, AND
//  DANIEL W. MCROBB HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT,
//  UPDATES, ENHANCEMENTS, OR MODIFICATIONS. DANIEL W. MCROBB MAKES NO
//  REPRESENTATIONS AND EXTENDS NO WARRANTIES OF ANY KIND, EITHER
//  IMPLIED OR EXPRESS, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
//  WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE,
//  OR THAT THE USE OF THIS SOFTWARE WILL NOT INFRINGE ANY PATENT,
//  TRADEMARK OR OTHER RIGHTS.
//===========================================================================

//---------------------------------------------------------------------------
//!  \file DwmMcroverZpoolAlert.cc
//!  \author Daniel W. McRobb
//!  \brief Dwm::Mcrover::ZpoolAlert class implementation
//---------------------------------------------------------------------------

#include "DwmDescriptorIO.hh"
#include "DwmFileIO.hh"
#include "DwmIOUtils.hh"
#include "DwmStreamIO.hh"
#include "DwmIpv4Address.hh"
#include "DwmSvnTag.hh"
#include "DwmMcroverZpoolAlert.hh"
#include "DwmMcroverUtils.hh"

static const Dwm::SvnTag svntag("@(#) $DwmPath: dwm/mcplex/mcrover/tags/mcrover-0.1.13/classes/src/DwmMcroverZpoolAlert.cc 11886 $");

namespace Dwm {

  namespace Mcrover {

    using namespace std;
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    ZpoolAlert::ZpoolAlert()
    {
      get<0>(_data) = Ipv4Address(INADDR_NONE);
      get<1>(_data) = "";
      get<2>(_data) = "";
      get<3>(_data) = 0;
    }
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    ZpoolAlert::ZpoolAlert(const Ipv4Address & localAddr, const string & pool,
                           const string & status)
    {
      get<0>(_data) = localAddr;
      get<1>(_data) = pool;
      get<2>(_data) = status;
      get<3>(_data) = 0;
    }

    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    ZpoolAlert::ZpoolAlert(const Ipv4Address & localAddr, const string & pool,
                           uint8_t percentFull)
    {
      get<0>(_data) = localAddr;
      get<1>(_data) = pool;
      get<2>(_data).clear();
      get<3>(_data) = percentFull;
    }
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    string ZpoolAlert::DisplayString() const
    {
      string  rc = get<1>(_data) + ':';
      if (! get<2>(_data).empty()) {
        rc += get<2>(_data);
      }
      else {
        rc += to_string((uint16_t)get<3>(_data)) + "%";
      }
      rc += " ZPOOL";
      return rc;
    }

    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    nlohmann::json ZpoolAlert::ToJson() const
    {
      nlohmann::json  j;
      j["local"] = (string)get<0>(_data);
      j["pool"] = get<1>(_data);
      if (! get<2>(_data).empty()) {
        j["status"] = get<2>(_data);
      }
      else {
        j["percent"] = (int)get<3>(_data);
      }
      return j;
    }
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    bool ZpoolAlert::FromJson(const nlohmann::json & j)
    {
      Clear();
      bool  rc = false;
      if (j.is_object()) {
        auto  local = j.find("local");
        if ((local != j.end()) && local->is_string()) {
          get<0>(_data) = Ipv4Address(local->get<string>());
          auto  pool = j.find("pool");
          if ((pool != j.end()) && pool->is_string()) {
            get<1>(_data) = pool->get<string>();
            auto  status = j.find("status");
            if ((status != j.end()) && status->is_string()) {
              get<2>(_data) = status->get<string>();
              rc = true;
            }
            else {
              auto percentFull = j.find("percent");
              if ((percentFull != j.end()) && percentFull->is_number()) {
                get<3>(_data) = percentFull->get<uint16_t>();
                rc = true;
              }
            }
          }
        }
      }
      return rc;
    }
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    istream & ZpoolAlert::Read(istream & is)
    {
      Clear();
      return StreamIO::Read(is, _data);
    }
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    ssize_t ZpoolAlert::Read(int fd)
    {
      Clear();
      return DescriptorIO::Read(fd, _data);
    }
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    size_t ZpoolAlert::Read(FILE * f)
    {
      Clear();
      return FileIO::Read(f, _data);
    }
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    ostream & ZpoolAlert::Write(ostream & os) const
    {
      return StreamIO::Write(os, _data);
    }
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    ssize_t ZpoolAlert::Write(int fd) const
    {
      return DescriptorIO::Write(fd, _data);
    }
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    size_t ZpoolAlert::Write(FILE *f) const
    {
      return FileIO::Write(f, _data);
    }
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    uint64_t ZpoolAlert::StreamedLength() const
    {
      return IOUtils::StreamedLength(_data);
    }
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    bool ZpoolAlert::operator == (const ZpoolAlert & alert) const
    {
      return (_data == alert._data);
    }

    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    void ZpoolAlert::Clear()
    {
      get<0>(_data) = INADDR_NONE;
      get<1>(_data).clear();
      get<2>(_data).clear();
      get<3>(_data) = 0;
    }
    
    
  }  // namespace Mcrover

}  // namespace Dwm
