//===========================================================================
// @(#) $DwmPath: dwm/mcplex/mcrover/tags/mcrover-0.1.13/classes/src/DwmMcroverWebTarget.cc 12167 $
// @(#) $Id: DwmMcroverWebTarget.cc 12167 2023-06-19 04:23:27Z dwm $
//===========================================================================
//  Copyright (c) Daniel W. McRobb 2020, 2023
//  All rights reserved.
//
//  Redistribution and use in source and binary forms, with or without
//  modification, are permitted provided that the following conditions
//  are met:
//
//  1. Redistributions of source code must retain the above copyright
//     notice, this list of conditions and the following disclaimer.
//  2. Redistributions in binary form must reproduce the above copyright
//     notice, this list of conditions and the following disclaimer in the
//     documentation and/or other materials provided with the distribution.
//  3. The names of the authors and copyright holders may not be used to
//     endorse or promote products derived from this software without
//     specific prior written permission.
//
//  IN NO EVENT SHALL DANIEL W. MCROBB BE LIABLE TO ANY PARTY FOR
//  DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES,
//  INCLUDING LOST PROFITS, ARISING OUT OF THE USE OF THIS SOFTWARE,
//  EVEN IF DANIEL W. MCROBB HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH
//  DAMAGE.
//
//  THE SOFTWARE PROVIDED HEREIN IS ON AN "AS IS" BASIS, AND
//  DANIEL W. MCROBB HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT,
//  UPDATES, ENHANCEMENTS, OR MODIFICATIONS. DANIEL W. MCROBB MAKES NO
//  REPRESENTATIONS AND EXTENDS NO WARRANTIES OF ANY KIND, EITHER
//  IMPLIED OR EXPRESS, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
//  WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE,
//  OR THAT THE USE OF THIS SOFTWARE WILL NOT INFRINGE ANY PATENT,
//  TRADEMARK OR OTHER RIGHTS.
//===========================================================================

//---------------------------------------------------------------------------
//!  \file DwmMcroverWebTarget.cc
//!  \author Daniel W. McRobb
//!  \brief Dwm::Mcrover::WebTarget class implementation
//---------------------------------------------------------------------------

#include "DwmSvnTag.hh"
#include "DwmMcroverWebTarget.hh"

static const Dwm::SvnTag svntag("@(#) $DwmPath: dwm/mcplex/mcrover/tags/mcrover-0.1.13/classes/src/DwmMcroverWebTarget.cc 12167 $");

namespace Dwm {

  namespace Mcrover {

    using namespace std;
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    const string & WebTarget::URI() const
    {
      return _uri;
    }

    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    const string & WebTarget::URI(const string & uri)
    {
      _uri = uri;
      return _uri;
    }

    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    const RangeSetPair<uint16_t> & WebTarget::GoodResponses() const
    {
      return _goodResponses;
    }

    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    RangeSetPair<uint16_t> & WebTarget::GoodResponses()
    {
      return _goodResponses;
    }
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    const RangeSetPair<uint16_t> &
    WebTarget::GoodResponses(const RangeSetPair<uint16_t> & goodResponses)
    {
      _goodResponses = goodResponses;
      return _goodResponses;
    }

    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    nlohmann::json WebTarget::ToJson() const
    {
      nlohmann::json  j;
      j["uri"] = _uri;
       auto it = _goodResponses.Pairs().begin();
      for (size_t i = 0; it != _goodResponses.Pairs().end(); ++it, ++i) {
        j["goodResponses"][i][0] = it->first;
        j["goodResponses"][i][1] = it->second;
      }
      return j;
    }

    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    bool WebTarget::FromJson(const nlohmann::json & j)
    {
      bool  rc = false;
      _uri.clear();
      _goodResponses.Clear();
      if (j.is_object()) {
        auto  it = j.find("uri");
        if ((it != j.end()) && it->is_string()) {
          _uri = it->get<string>();
          it = j.find("goodResponses");
          if ((it != j.end()) && it->is_array()) {
            for (size_t g = 0; g < it->size(); ++g) {
              if ((*it)[g].is_array() && ((*it)[g].size() == 2)) {
                _goodResponses.AddRange({
                    (*it)[g][0].get<uint16_t>(),
                    (*it)[g][1].get<uint16_t>()
                  });
              }
            }
            rc = true;
          }
        }
      }
      return rc;
    }
    
    
  }  // namespace Mcrover

}  // namespace Dwm
