//===========================================================================
//  Copyright (c) Daniel W. McRobb 2021, 2022
//  All rights reserved.
//
//  Redistribution and use in source and binary forms, with or without
//  modification, are permitted provided that the following conditions
//  are met:
//
//  1. Redistributions of source code must retain the above copyright
//     notice, this list of conditions and the following disclaimer.
//  2. Redistributions in binary form must reproduce the above copyright
//     notice, this list of conditions and the following disclaimer in the
//     documentation and/or other materials provided with the distribution.
//  3. The names of the authors and copyright holders may not be used to
//     endorse or promote products derived from this software without
//     specific prior written permission.
//
//  IN NO EVENT SHALL DANIEL W. MCROBB BE LIABLE TO ANY PARTY FOR
//  DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES,
//  INCLUDING LOST PROFITS, ARISING OUT OF THE USE OF THIS SOFTWARE,
//  EVEN IF DANIEL W. MCROBB HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH
//  DAMAGE.
//
//  THE SOFTWARE PROVIDED HEREIN IS ON AN "AS IS" BASIS, AND
//  DANIEL W. MCROBB HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT,
//  UPDATES, ENHANCEMENTS, OR MODIFICATIONS. DANIEL W. MCROBB MAKES NO
//  REPRESENTATIONS AND EXTENDS NO WARRANTIES OF ANY KIND, EITHER
//  IMPLIED OR EXPRESS, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
//  WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE,
//  OR THAT THE USE OF THIS SOFTWARE WILL NOT INFRINGE ANY PATENT,
//  TRADEMARK OR OTHER RIGHTS.
//===========================================================================

//---------------------------------------------------------------------------
//!  \file DwmMcroverHTTPUtils.cc
//!  \author Daniel W. McRobb
//!  \brief Dwm::Mcrover::HTTPUtils class implementation
//---------------------------------------------------------------------------

#include <chrono>
#include <map>
#include <memory>
#include <thread>

#include "DwmSvnTag.hh"
#include "DwmSysLogger.hh"
#include "DwmMcroverTargetHostConfig.hh"
#include "DwmMcroverTcp4DstAddr.hh"
#include "DwmMcroverWebAppUtils.hh"
#include "DwmMcroverWebAppStatusHandler.hh"

namespace Dwm {

  namespace Mcrover {

    using namespace std;

    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    bool WebAppUtils::GetAlerts(const AlertOrigin & origin,
                                   const std::vector<TargetHostConfig> & hosts,
                                   AlertBowl & alerts, bool clearAtEntry)
    {
      bool  rc = false;
      if (clearAtEntry) {
        alerts.Clear();
      }
      vector<WebAppStatusJob>  jobs;
      for (const auto & host : hosts) {
        if (! host.WebAppTargets().empty()) {
          for (auto target : host.WebAppTargets()) {
            WebAppStatusJob  job;
            job.name = host.Name();
            job.addr = host.PreferredAddress();
            job.webAppTarget = target;
            job.getFail.FailNum(WebUtils::GetFailure::k_failNumNone);
            jobs.push_back(job);
          }
        }
      }
      if (! jobs.empty()) {
        LoadBalancer<WebAppStatusJob>  loadBalancer;
        WebAppStatusHandler            statusHandler(origin, alerts);
        for (size_t i = 0; (i < jobs.size()) && (i < 16); ++i) {
          loadBalancer.AddWorker(new WebAppWorker(statusHandler));
        }
        for (const auto & job : jobs) {
          loadBalancer.AddWork(job);
        }
        loadBalancer.Stop();
        Syslog(LOG_INFO, "HTTP WebApp load balancer done.");
      }
      return rc;
    }
    
  }  // namespace Mcrover

}  // namespace Dwm
