//===========================================================================
// @(#) $Name:$
// @(#) $Id: DwmMcroverTcpTestConnectData.cc 11361 2020-12-09 01:51:55Z dwm $
//===========================================================================
//  Copyright (c) Daniel W. McRobb 2020
//  All rights reserved.
//
//  Redistribution and use in source and binary forms, with or without
//  modification, are permitted provided that the following conditions
//  are met:
//
//  1. Redistributions of source code must retain the above copyright
//     notice, this list of conditions and the following disclaimer.
//  2. Redistributions in binary form must reproduce the above copyright
//     notice, this list of conditions and the following disclaimer in the
//     documentation and/or other materials provided with the distribution.
//  3. The names of the authors and copyright holders may not be used to
//     endorse or promote products derived from this software without
//     specific prior written permission.
//
//  IN NO EVENT SHALL DANIEL W. MCROBB BE LIABLE TO ANY PARTY FOR
//  DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES,
//  INCLUDING LOST PROFITS, ARISING OUT OF THE USE OF THIS SOFTWARE,
//  EVEN IF DANIEL W. MCROBB HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH
//  DAMAGE.
//
//  THE SOFTWARE PROVIDED HEREIN IS ON AN "AS IS" BASIS, AND
//  DANIEL W. MCROBB HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT,
//  UPDATES, ENHANCEMENTS, OR MODIFICATIONS. DANIEL W. MCROBB MAKES NO
//  REPRESENTATIONS AND EXTENDS NO WARRANTIES OF ANY KIND, EITHER
//  IMPLIED OR EXPRESS, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
//  WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE,
//  OR THAT THE USE OF THIS SOFTWARE WILL NOT INFRINGE ANY PATENT,
//  TRADEMARK OR OTHER RIGHTS.
//===========================================================================

//---------------------------------------------------------------------------
//!  \file DwmMcroverTcpTestConnectData.cc
//!  \brief Dwm::Mcrover::TcpTestConnectData class implementation
//---------------------------------------------------------------------------

extern "C" {
  #include <unistd.h>
}

#include "DwmDescriptorIO.hh"
#include "DwmFileIO.hh"
#include "DwmIOUtils.hh"
#include "DwmStreamIO.hh"
#include "DwmSvnTag.hh"
#include "DwmMcroverTcpTestConnectData.hh"

static const Dwm::SvnTag svntag("@(#) $DwmPath: dwm/mcplex/mcrover/tags/mcrover-0.1.13/classes/src/DwmMcroverTcpTestConnectData.cc 11361 $");

namespace Dwm {

  namespace Mcrover {

    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    TcpTestConnectData::TcpTestConnectData()
        : _lastPassed(0), _lastFailed(0)
    {}
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    time_t TcpTestConnectData::LastPassed() const
    {
      return _lastPassed;
    }
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    time_t TcpTestConnectData::LastPassed(time_t lastPassed)
    {
      _lastPassed = lastPassed;
      return _lastPassed;
    }
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    time_t TcpTestConnectData::LastFailed() const
    {
      return _lastFailed;
    }
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    time_t TcpTestConnectData::LastFailed(time_t lastFailed)
    {
      _lastFailed = lastFailed;
      return _lastFailed;
    }

    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    bool TcpTestConnectData::Passed() const
    {
      return (_lastPassed > _lastFailed);
    }

    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    std::istream & TcpTestConnectData::Read(std::istream & is)
    {
      if (is) {
        if (Dwm::StreamIO::Read(is, _lastPassed)) {
          Dwm::StreamIO::Read(is, _lastFailed);
        }
      }
      return is;
    }
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    ssize_t TcpTestConnectData::Read(int fd)
    {
      ssize_t  rc = -1;
      if (fd >= 0) {
        ssize_t  bytesRead = Dwm::DescriptorIO::Read(fd, _lastPassed);
        if (bytesRead > 0) {
          rc = bytesRead;
          bytesRead = Dwm::DescriptorIO::Read(fd, _lastFailed);
          if (bytesRead > 0) {
            rc += bytesRead;
          }
          else {
            rc = -1;
          }
        }
      }
      return rc;
    }
            
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    size_t TcpTestConnectData::Read(FILE * f)
    {
      size_t  rc = 0;
      if (f) {
        if (Dwm::FileIO::Read(f, _lastPassed)) {
          rc = Dwm::FileIO::Read(f, _lastFailed);
        }
      }
      return rc;
    }
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    std::ostream & TcpTestConnectData::Write(std::ostream & os) const
    {
      if (os) {
        if (Dwm::StreamIO::Write(os, _lastPassed)) {
          Dwm::StreamIO::Write(os, _lastFailed);
        }
      }
      return os;
    }
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    ssize_t TcpTestConnectData::Write(int fd) const
    {
      ssize_t  rc = -1;
      if (fd >= 0) {
        ssize_t  bytesWritten = Dwm::DescriptorIO::Write(fd, _lastPassed);
        if (bytesWritten > 0) {
          rc = bytesWritten;
          bytesWritten = Dwm::DescriptorIO::Write(fd, _lastFailed);
          if (bytesWritten > 0) {
            rc += bytesWritten;
          }
          else {
            rc = -1;
          }
        }
      }
      return rc;
    }
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    size_t TcpTestConnectData::Write(FILE *f) const
    {
      size_t  rc = 0;
      if (f) {
        if (Dwm::FileIO::Write(f, _lastPassed)) {
          rc = Dwm::FileIO::Write(f, _lastFailed);
        }
      }
      return rc;
    }
    
  }  // namespace Mcrover
  
}  // namespace Dwm
