%{
  #include "DwmMcroverShortForecastParser.hh"

  extern string  g_forecastString;
    
  extern "C" {
    #include <stdarg.h>

    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    void mcrovershortforecasterror(const char *arg, ...)
    {
      va_list  ap;
      va_start(ap, arg);
      vfprintf(stderr, arg, ap);
      fprintf(stderr, ": '%s' at line %d in %s\n", yytext, yylineno,
              g_forecastString.c_str());
      return;
    }
  }
  
%}

%option noyywrap
%option prefix="mcrovershortforecast"
%option yylineno
 
%%

Thunderstorms { return THUNDERSTORMS; }
Isolated    { return ISOLATED; }
Showers     { return SHOWERS;  }
Chance      { return CHANCE;   }
Cloudy      { return CLOUDY;   }
Likely      { return LIKELY;   }
Mostly      { return MOSTLY;   }
Partly      { return PARTLY;   }
Slight      { return SLIGHT;   }
Clear       { return CLEAR;    }
Light       { return LIGHT;    }
Sunny       { return SUNNY;    }
Areas       { return AREAS;    }
Rain        { return RAIN;     }
Snow        { return SNOW;     }
[Tt]hen     { return THEN;     }
And         { return AND;      }
Fog         { return FOG;      }
Of          { return OF;       }

[ \t\n\0]+
.
<<EOF>>     { return 0; }

%%

void SetForecastScanString(const char *s)
{
  yy_switch_to_buffer(yy_scan_string(s));
  return;
}

void EndShortForecastScan()
{
  yy_delete_buffer(YY_CURRENT_BUFFER);
}
