//===========================================================================
// @(#) $DwmPath: dwm/mcplex/mcrover/tags/mcrover-0.1.13/classes/src/DwmMcroverFilesystemAlert.cc 12281 $
// @(#) $Id: DwmMcroverFilesystemAlert.cc 12281 2023-11-11 16:19:01Z dwm $
//===========================================================================
//  Copyright (c) Daniel W. McRobb 2020
//  All rights reserved.
//
//  Redistribution and use in source and binary forms, with or without
//  modification, are permitted provided that the following conditions
//  are met:
//
//  1. Redistributions of source code must retain the above copyright
//     notice, this list of conditions and the following disclaimer.
//  2. Redistributions in binary form must reproduce the above copyright
//     notice, this list of conditions and the following disclaimer in the
//     documentation and/or other materials provided with the distribution.
//  3. The names of the authors and copyright holders may not be used to
//     endorse or promote products derived from this software without
//     specific prior written permission.
//
//  IN NO EVENT SHALL DANIEL W. MCROBB BE LIABLE TO ANY PARTY FOR
//  DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES,
//  INCLUDING LOST PROFITS, ARISING OUT OF THE USE OF THIS SOFTWARE,
//  EVEN IF DANIEL W. MCROBB HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH
//  DAMAGE.
//
//  THE SOFTWARE PROVIDED HEREIN IS ON AN "AS IS" BASIS, AND
//  DANIEL W. MCROBB HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT,
//  UPDATES, ENHANCEMENTS, OR MODIFICATIONS. DANIEL W. MCROBB MAKES NO
//  REPRESENTATIONS AND EXTENDS NO WARRANTIES OF ANY KIND, EITHER
//  IMPLIED OR EXPRESS, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
//  WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE,
//  OR THAT THE USE OF THIS SOFTWARE WILL NOT INFRINGE ANY PATENT,
//  TRADEMARK OR OTHER RIGHTS.
//===========================================================================

//---------------------------------------------------------------------------
//!  \file DwmMcroverFilesystemAlert.cc
//!  \author Daniel W. McRobb
//!  \brief Dwm::Mcrover::FilesystemAlert class implementation
//---------------------------------------------------------------------------

#include "DwmDescriptorIO.hh"
#include "DwmFileIO.hh"
#include "DwmIOUtils.hh"
#include "DwmStreamIO.hh"
#include "DwmIpv4Address.hh"
#include "DwmSvnTag.hh"
#include "DwmMcroverFilesystemAlert.hh"
#include "DwmMcroverUtils.hh"

static const Dwm::SvnTag svntag("@(#) $DwmPath: dwm/mcplex/mcrover/tags/mcrover-0.1.13/classes/src/DwmMcroverFilesystemAlert.cc 12281 $");

namespace Dwm {

  namespace Mcrover {

    using namespace std;
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    FilesystemAlert::FilesystemAlert()
    {
      get<0>(_data) = Ipv4Address(INADDR_NONE);
      get<1>(_data) = "";
      get<2>(_data) = true;
      get<3>(_data) = 0;
    }
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    FilesystemAlert::FilesystemAlert(const Ipv4Address & localAddr,
                                     const string & mountPoint)
    {
      get<0>(_data) = localAddr;
      get<1>(_data) = mountPoint;
      get<2>(_data) = false;
      get<3>(_data) = 0;
    }

    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    FilesystemAlert::FilesystemAlert(const Ipv4Address & localAddr,
                                     const string & mountPoint,
                                     uint8_t percentFull)
    {
      get<0>(_data) = localAddr;
      get<1>(_data) = mountPoint;
      get<2>(_data) = true;
      get<3>(_data) = percentFull;
    }
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    string FilesystemAlert::DisplayString() const
    {
      string  rc = get<1>(_data) + ':';
      if (! get<2>(_data)) {
        rc += "not_mounted";
      }
      else {
        rc += to_string((uint16_t)get<3>(_data)) + "%";
      }
      rc += " FILESYSTEM";
      return rc;
    }

    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    nlohmann::json FilesystemAlert::ToJson() const
    {
      nlohmann::json  j;
      j["local"] = (string)get<0>(_data);
      j["mount"] = get<1>(_data);
      if (! get<2>(_data)) {
        j["mounted"] = get<2>(_data);
      }
      else {
        j["percent"] = (int)get<3>(_data);
      }
      return j;
    }
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    bool FilesystemAlert::FromJson(const nlohmann::json & j)
    {
      Clear();
      bool  rc = false;
      if (j.is_object()) {
        auto  local = j.find("local");
        if ((local != j.end()) && local->is_string()) {
          get<0>(_data) = Ipv4Address(local->get<string>());
          auto  pool = j.find("mount");
          if ((pool != j.end()) && pool->is_string()) {
            get<1>(_data) = pool->get<string>();
            auto  mounted = j.find("mounted");
            if ((mounted != j.end()) && mounted->is_boolean()) {
              get<2>(_data) = mounted->get<bool>();
              rc = true;
            }
            else {
              auto percentFull = j.find("percent");
              if ((percentFull != j.end()) && percentFull->is_number()) {
                get<3>(_data) = percentFull->get<uint16_t>();
                rc = true;
              }
            }
          }
        }
      }
      return rc;
    }
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    istream & FilesystemAlert::Read(istream & is)
    {
      Clear();
      return StreamIO::Read(is, _data);
    }
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    ssize_t FilesystemAlert::Read(int fd)
    {
      Clear();
      return DescriptorIO::Read(fd, _data);
    }
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    size_t FilesystemAlert::Read(FILE * f)
    {
      Clear();
      return FileIO::Read(f, _data);
    }
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    ostream & FilesystemAlert::Write(ostream & os) const
    {
      return StreamIO::Write(os, _data);
    }
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    ssize_t FilesystemAlert::Write(int fd) const
    {
      return DescriptorIO::Write(fd, _data);
    }
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    size_t FilesystemAlert::Write(FILE *f) const
    {
      return FileIO::Write(f, _data);
    }
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    uint64_t FilesystemAlert::StreamedLength() const
    {
      return IOUtils::StreamedLength(_data);
    }
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    void FilesystemAlert::Clear()
    {
      get<0>(_data) = INADDR_NONE;
      get<1>(_data).clear();
      get<2>(_data) = true;
      get<3>(_data) = 0;
    }
    
    
  }  // namespace Mcrover

}  // namespace Dwm
