//===========================================================================
// @(#) $DwmPath: dwm/mcplex/mcrover/trunk/classes/include/DwmMcroverTcp6Utils.hh 10997 $
// @(#) $Id: DwmMcroverTcp6Utils.hh 10997 2020-08-27 05:34:16Z dwm $
//===========================================================================
//  Copyright (c) Daniel W. McRobb 2020
//  All rights reserved.
//
//  Redistribution and use in source and binary forms, with or without
//  modification, are permitted provided that the following conditions
//  are met:
//
//  1. Redistributions of source code must retain the above copyright
//     notice, this list of conditions and the following disclaimer.
//  2. Redistributions in binary form must reproduce the above copyright
//     notice, this list of conditions and the following disclaimer in the
//     documentation and/or other materials provided with the distribution.
//  3. The names of the authors and copyright holders may not be used to
//     endorse or promote products derived from this software without
//     specific prior written permission.
//
//  IN NO EVENT SHALL DANIEL W. MCROBB BE LIABLE TO ANY PARTY FOR
//  DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES,
//  INCLUDING LOST PROFITS, ARISING OUT OF THE USE OF THIS SOFTWARE,
//  EVEN IF DANIEL W. MCROBB HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH
//  DAMAGE.
//
//  THE SOFTWARE PROVIDED HEREIN IS ON AN "AS IS" BASIS, AND
//  DANIEL W. MCROBB HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT,
//  UPDATES, ENHANCEMENTS, OR MODIFICATIONS. DANIEL W. MCROBB MAKES NO
//  REPRESENTATIONS AND EXTENDS NO WARRANTIES OF ANY KIND, EITHER
//  IMPLIED OR EXPRESS, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
//  WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE,
//  OR THAT THE USE OF THIS SOFTWARE WILL NOT INFRINGE ANY PATENT,
//  TRADEMARK OR OTHER RIGHTS.
//===========================================================================

//---------------------------------------------------------------------------
//!  \file DwmMcroverTcp6Utils.hh
//!  \author Daniel W. McRobb
//!  \brief Dwm::Mcrover::Tcp6Utils class declaration
//---------------------------------------------------------------------------

#ifndef _DWMMCROVERTCP6UTILS_HH_
#define _DWMMCROVERTCP6UTILS_HH_

#include <chrono>
#include <map>

#include "DwmMcroverAlertBowl.hh"
#include "DwmMcroverTargetHostConfig.hh"
#include "DwmMcroverTcpTestConnectData.hh"

namespace Dwm {

  namespace Mcrover {

    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    class Tcp6Utils
    {
    public:
      //----------------------------------------------------------------------
      //!  
      //----------------------------------------------------------------------
      static bool GetAlerts(const AlertOrigin & origin,
                            const std::vector<TargetHostConfig> & hosts,
                            AlertBowl & alerts,
                            bool clearAtEntry = false);
      
      //----------------------------------------------------------------------
      //!  
      //----------------------------------------------------------------------
      static void TestConnect(std::map<Tcp6DstAddr,TcpTestConnectData> & dm,
                              std::chrono::milliseconds timeOut =
                              std::chrono::milliseconds(5000));
    };
    
  }  // namespace Mcrover

}  // namespace Dwm

#endif  // _DWMMCROVERTCP6UTILS_HH_
