//===========================================================================
// @(#) $DwmPath$
//===========================================================================
//  Copyright (c) Daniel W. McRobb 2022
//  All rights reserved.
//
//  Redistribution and use in source and binary forms, with or without
//  modification, are permitted provided that the following conditions
//  are met:
//
//  1. Redistributions of source code must retain the above copyright
//     notice, this list of conditions and the following disclaimer.
//  2. Redistributions in binary form must reproduce the above copyright
//     notice, this list of conditions and the following disclaimer in the
//     documentation and/or other materials provided with the distribution.
//  3. The names of the authors and copyright holders may not be used to
//     endorse or promote products derived from this software without
//     specific prior written permission.
//
//  IN NO EVENT SHALL DANIEL W. MCROBB BE LIABLE TO ANY PARTY FOR
//  DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES,
//  INCLUDING LOST PROFITS, ARISING OUT OF THE USE OF THIS SOFTWARE,
//  EVEN IF DANIEL W. MCROBB HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH
//  DAMAGE.
//
//  THE SOFTWARE PROVIDED HEREIN IS ON AN "AS IS" BASIS, AND
//  DANIEL W. MCROBB HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT,
//  UPDATES, ENHANCEMENTS, OR MODIFICATIONS. DANIEL W. MCROBB MAKES NO
//  REPRESENTATIONS AND EXTENDS NO WARRANTIES OF ANY KIND, EITHER
//  IMPLIED OR EXPRESS, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
//  WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE,
//  OR THAT THE USE OF THIS SOFTWARE WILL NOT INFRINGE ANY PATENT,
//  TRADEMARK OR OTHER RIGHTS.
//===========================================================================

//---------------------------------------------------------------------------
//!  \file DwmMcroverPackMemberStatus.hh
//!  \author Daniel W. McRobb
//!  \brief NOT YET DOCUMENTED
//---------------------------------------------------------------------------

#ifndef _DWMMCROVERPACKMEMBERSTATUS_HH_
#define _DWMMCROVERPACKMEMBERSTATUS_HH_

#include <cstdint>
#include <tuple>

#include "DwmStreamIOCapable.hh"
#include "DwmStreamedLengthCapable.hh"

namespace Dwm {

  namespace Mcrover {

    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    class PackMemberStatus
      : public Dwm::StreamIOCapable, public Dwm::StreamedLengthCapable
    {
    public:
      //----------------------------------------------------------------------
      //!  
      //----------------------------------------------------------------------
      PackMemberStatus()
          : _data({0, 0, "", ""})
      { }
      
      //----------------------------------------------------------------------
      //!  
      //----------------------------------------------------------------------
      PackMemberStatus(const PackMemberStatus &) = default;

      //----------------------------------------------------------------------
      //!  
      //----------------------------------------------------------------------
      PackMemberStatus & operator = (const PackMemberStatus &) = default;
      
      //----------------------------------------------------------------------
      //!  
      //----------------------------------------------------------------------
      const std::uint64_t & LastSend() const
      { return std::get<0>(_data); }

      //----------------------------------------------------------------------
      //!  
      //----------------------------------------------------------------------
      const std::uint64_t & LastSend(const uint64_t & lastSend)
      { return std::get<0>(_data) = lastSend; }

      //----------------------------------------------------------------------
      //!  
      //----------------------------------------------------------------------
      const std::uint64_t & LastReceive() const
      { return std::get<1>(_data); }

      //----------------------------------------------------------------------
      //!  
      //----------------------------------------------------------------------
      const std::uint64_t & LastReceive(const uint64_t & lastReceive)
      { return std::get<1>(_data) = lastReceive; }
      
      //----------------------------------------------------------------------
      //!  
      //----------------------------------------------------------------------
      const std::string & LastSendAddr() const
      { return std::get<2>(_data); }

      //----------------------------------------------------------------------
      //!  
      //----------------------------------------------------------------------
      const std::string & LastSendAddr(const std::string & lastSendAddr)
      { return std::get<2>(_data) = lastSendAddr; }

      //----------------------------------------------------------------------
      //!  
      //----------------------------------------------------------------------
      const std::string & LastReceiveAddr() const
      { return std::get<3>(_data); }

      //----------------------------------------------------------------------
      //!  
      //----------------------------------------------------------------------
      const std::string & LastReceiveAddr(const std::string & lastReceiveAddr)
      { return std::get<3>(_data) = lastReceiveAddr; }
      

      void Clear();
      
      virtual std::istream & Read(std::istream & is) override;
      virtual std::ostream & Write(std::ostream & os) const override;
      virtual uint64_t StreamedLength() const override;

    private:
      std::tuple<std::uint64_t,   // LastSend
                 std::uint64_t,   // LastReceive
                 std::string,     // LastSendAddr
                 std::string      // LastReceiveAddr
                 >   _data;
    };
    
  }  // namespace Mcrover

}  // namespace Dwm

#endif  // _DWMMCROVERPACKMEMBERSTATUS_HH_
