//===========================================================================
// @(#) $DwmPath: dwm/mcplex/mcrover/tags/mcrover-0.1.13/classes/include/DwmMcroverDiskAlert.hh 11886 $
// @(#) $Id: DwmMcroverDiskAlert.hh 11886 2021-04-07 05:16:39Z dwm $
//===========================================================================
//  Copyright (c) Daniel W. McRobb 2020
//  All rights reserved.
//
//  Redistribution and use in source and binary forms, with or without
//  modification, are permitted provided that the following conditions
//  are met:
//
//  1. Redistributions of source code must retain the above copyright
//     notice, this list of conditions and the following disclaimer.
//  2. Redistributions in binary form must reproduce the above copyright
//     notice, this list of conditions and the following disclaimer in the
//     documentation and/or other materials provided with the distribution.
//  3. The names of the authors and copyright holders may not be used to
//     endorse or promote products derived from this software without
//     specific prior written permission.
//
//  IN NO EVENT SHALL DANIEL W. MCROBB BE LIABLE TO ANY PARTY FOR
//  DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES,
//  INCLUDING LOST PROFITS, ARISING OUT OF THE USE OF THIS SOFTWARE,
//  EVEN IF DANIEL W. MCROBB HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH
//  DAMAGE.
//
//  THE SOFTWARE PROVIDED HEREIN IS ON AN "AS IS" BASIS, AND
//  DANIEL W. MCROBB HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT,
//  UPDATES, ENHANCEMENTS, OR MODIFICATIONS. DANIEL W. MCROBB MAKES NO
//  REPRESENTATIONS AND EXTENDS NO WARRANTIES OF ANY KIND, EITHER
//  IMPLIED OR EXPRESS, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
//  WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE,
//  OR THAT THE USE OF THIS SOFTWARE WILL NOT INFRINGE ANY PATENT,
//  TRADEMARK OR OTHER RIGHTS.
//===========================================================================

//---------------------------------------------------------------------------
//!  \file DwmMcroverDiskAlert.hh
//!  \author Daniel W. McRobb
//!  \brief NOT YET DOCUMENTED
//---------------------------------------------------------------------------

#ifndef _DWMMCROVERDISKALERT_HH_
#define _DWMMCROVERDISKALERT_HH_

#include <utility>

#include "DwmIpv4Address.hh"
#include "DwmMcroverAlertBase.hh"

namespace Dwm {

  namespace Mcrover {

    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    class DiskAlert
      : public AlertBase
    {
    public:
      DiskAlert();
      DiskAlert(const Ipv4Address & localAddr,
                const std::pair<std::string,std::string> & disk);
      
      uint8_t Priority() const override { return 1; }
      std::string DisplayString() const override;
      nlohmann::json ToJson() const override;
      bool FromJson(const nlohmann::json & j) override;

      std::istream & Read(std::istream & is) override;
      ssize_t Read(int fd) override;
      size_t Read(FILE * f) override;
      std::ostream & Write(std::ostream & os) const override;
      ssize_t Write(int fd) const override;
      size_t Write(FILE *f) const override;
      uint64_t StreamedLength() const override;

      bool operator == (const DiskAlert & alert) const
      { return (_data == alert._data); }

      bool operator < (const DiskAlert & alert) const
      { return (_data < alert._data); }

      const std::string & Device() const
      { return _data.second.first; }

      const std::string & Name() const
      { return _data.second.second; }
        
    private:
      std::pair<Ipv4Address,std::pair<std::string,std::string>>  _data;
      
      void Clear();
    };
    
  }  // namespace Mcrover

}  // namespace Dwm

#endif  // _DWMMCROVERDISKALERT_HH_
