//===========================================================================
// @(#) $DwmPath: dwm/mcplex/mcrover/tags/mcrover-0.1.13/classes/include/DwmMcroverAlertOrigin.hh 11959 $
// @(#) $Id: DwmMcroverAlertOrigin.hh 11959 2022-04-23 15:49:38Z dwm $
//===========================================================================
//  Copyright (c) Daniel W. McRobb 2020
//  All rights reserved.
//
//  Redistribution and use in source and binary forms, with or without
//  modification, are permitted provided that the following conditions
//  are met:
//
//  1. Redistributions of source code must retain the above copyright
//     notice, this list of conditions and the following disclaimer.
//  2. Redistributions in binary form must reproduce the above copyright
//     notice, this list of conditions and the following disclaimer in the
//     documentation and/or other materials provided with the distribution.
//  3. The names of the authors and copyright holders may not be used to
//     endorse or promote products derived from this software without
//     specific prior written permission.
//
//  IN NO EVENT SHALL DANIEL W. MCROBB BE LIABLE TO ANY PARTY FOR
//  DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES,
//  INCLUDING LOST PROFITS, ARISING OUT OF THE USE OF THIS SOFTWARE,
//  EVEN IF DANIEL W. MCROBB HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH
//  DAMAGE.
//
//  THE SOFTWARE PROVIDED HEREIN IS ON AN "AS IS" BASIS, AND
//  DANIEL W. MCROBB HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT,
//  UPDATES, ENHANCEMENTS, OR MODIFICATIONS. DANIEL W. MCROBB MAKES NO
//  REPRESENTATIONS AND EXTENDS NO WARRANTIES OF ANY KIND, EITHER
//  IMPLIED OR EXPRESS, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
//  WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE,
//  OR THAT THE USE OF THIS SOFTWARE WILL NOT INFRINGE ANY PATENT,
//  TRADEMARK OR OTHER RIGHTS.
//===========================================================================

//---------------------------------------------------------------------------
//!  \file DwmMcroverAlertOrigin.hh
//!  \author Daniel W. McRobb
//!  \brief Dwm::Mcrover::AlertOrigin class declaration
//---------------------------------------------------------------------------

#ifndef _DWMMCROVERALERTORIGIN_HH_
#define _DWMMCROVERALERTORIGIN_HH_

// #include "DwmIpv4Address.hh"
#include "DwmIpAddress.hh"
#include "DwmDescriptorIOCapable.hh"
#include "DwmFileIOCapable.hh"
#include "DwmStreamIOCapable.hh"
#include "DwmStreamedLengthCapable.hh"

namespace Dwm {

  namespace Mcrover {

    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    class AlertOrigin
      : public DescriptorIOCapable, public FileIOCapable,
        public StreamIOCapable, public StreamedLengthCapable
    {
    public:
      AlertOrigin() = default;
      AlertOrigin(AlertOrigin &&) = default;
      AlertOrigin(const AlertOrigin &) = default;
      AlertOrigin & operator = (const AlertOrigin &) = default;
      ~AlertOrigin() = default;
      AlertOrigin(const std::string & packName,
                  const IpAddress & memberAddr);
      const std::string & PackName() const;
      const std::string & PackName(const std::string & packName);
#if 0
      const Ipv4Address & MemberAddress() const;
      const Ipv4Address & MemberAddress(const Ipv4Address & memberAddr);
#else
      const IpAddress & MemberAddress() const;
      const IpAddress & MemberAddress(const IpAddress & memberAddr);
#endif
      std::istream & Read(std::istream & is) override;
      ssize_t Read(int fd) override;
      size_t Read(FILE * f) override;
      std::ostream & Write(std::ostream & os) const override;
      ssize_t Write(int fd) const override;
      size_t Write(FILE *f) const override;
      uint64_t StreamedLength() const override;

      bool operator == (const AlertOrigin & origin) const
      { return (_data == origin._data); }
        
      bool operator < (const AlertOrigin & origin) const
      { return (_data < origin._data); }
      
    private:
      // std::tuple<std::string,Ipv4Address>  _data;
      std::tuple<std::string,IpAddress>  _data;
    };
    
  }  // namespace Mcrover

}  // namespace Dwm

#endif  // _DWMMCROVERALERTORIGIN_HH_
