#include <QHeaderView>
#include <QPainter>

namespace Dwm {

  namespace Mcrover {

    class QRotatedHeaderView
      : public QHeaderView
    {
      Q_OBJECT
      
    public:
      QRotatedHeaderView(Qt::Orientation orientation,
                                    QWidget *parent = nullptr);
      void paintSection(QPainter *painter, const QRect & rect,
                        int logicalIndex) const override;
      QSize sizeHint() const override;

    protected:
      int           _margin;
      QFontMetrics  _metrics;
      int           _descent;
      
      QVariant getData(int section) const;
      int getTextWidth() const;
    };
    
  }  // namespace Mcrover

}  // namespace Dwm
