//===========================================================================
// @(#) $Name:$
// @(#) $Id: DwmMcroverPageButton.cc 10997 2020-08-27 05:34:16Z dwm $
//===========================================================================
//  Copyright (c) Daniel W. McRobb 2020
//  All rights reserved.
//
//  Redistribution and use in source and binary forms, with or without
//  modification, are permitted provided that the following conditions
//  are met:
//
//  1. Redistributions of source code must retain the above copyright
//     notice, this list of conditions and the following disclaimer.
//  2. Redistributions in binary form must reproduce the above copyright
//     notice, this list of conditions and the following disclaimer in the
//     documentation and/or other materials provided with the distribution.
//  3. The names of the authors and copyright holders may not be used to
//     endorse or promote products derived from this software without
//     specific prior written permission.
//
//  IN NO EVENT SHALL DANIEL W. MCROBB BE LIABLE TO ANY PARTY FOR
//  DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES,
//  INCLUDING LOST PROFITS, ARISING OUT OF THE USE OF THIS SOFTWARE,
//  EVEN IF DANIEL W. MCROBB HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH
//  DAMAGE.
//
//  THE SOFTWARE PROVIDED HEREIN IS ON AN "AS IS" BASIS, AND
//  DANIEL W. MCROBB HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT,
//  UPDATES, ENHANCEMENTS, OR MODIFICATIONS. DANIEL W. MCROBB MAKES NO
//  REPRESENTATIONS AND EXTENDS NO WARRANTIES OF ANY KIND, EITHER
//  IMPLIED OR EXPRESS, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
//  WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE,
//  OR THAT THE USE OF THIS SOFTWARE WILL NOT INFRINGE ANY PATENT,
//  TRADEMARK OR OTHER RIGHTS.
//===========================================================================

//---------------------------------------------------------------------------
//!  \file DwmMcroverPageButton.cc
//!  \brief NOT YET DOCUMENTED
//---------------------------------------------------------------------------

#include "DwmSvnTag.hh"
#include "DwmMcroverPageButton.hh"

static const Dwm::SvnTag svntag("@(#) $DwmPath: dwm/mcplex/mcrover/tags/mcrover-0.1.13/apps/qmcrover/DwmMcroverPageButton.cc 10997 $");

namespace Dwm {

  namespace Mcrover {

    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    PageButton::PageButton(QWidget *parent, Qt::WindowFlags f)
        : QLabel(parent, f)
    {}

    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    void PageButton::setImage(const QImage & image)
    {
      QPixmap pxm;
      pxm.convertFromImage(image.scaled(width(), height(),
                                        Qt::KeepAspectRatio,
                                        Qt::SmoothTransformation));
      setPixmap(pxm);
    }
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    void PageButton::mousePressEvent(QMouseEvent *e)
    {
      if (e->pos().x() < width() / 2) {
        setStyleSheet("background-color: qlineargradient(x1:0, y1:0.5, "
                      "x2:1, y2:0.5, stop:0 #EC6500, stop: 1 #000040);");
        emit pressedLeft();
      }
      else {
        setStyleSheet("background-color: qlineargradient(x1:0, y1:0.5, "
                      "x2:1, y2:0.5, stop:0 #000040, stop: 1 #EC6500);");
        emit pressedRight();
      }
      return;
    }
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    void PageButton::mouseReleaseEvent(QMouseEvent *e)
    {
      setStyleSheet("color: white;" /* background-color: #000000;" */);
      return;
    }
    

  }  // namespace Mcrover

}  // namespace Dwm
