//===========================================================================
// @(#) $DwmPath: dwm/mcplex/mcrover/tags/mcrover-0.1.13/apps/qmcrover/DwmMcroverCurrentWeatherWidget.hh 11932 $
// @(#) $Id: DwmMcroverCurrentWeatherWidget.hh 11932 2022-04-11 02:01:48Z dwm $
//===========================================================================
//  Copyright (c) Daniel W. McRobb 2020
//  All rights reserved.
//
//  Redistribution and use in source and binary forms, with or without
//  modification, are permitted provided that the following conditions
//  are met:
//
//  1. Redistributions of source code must retain the above copyright
//     notice, this list of conditions and the following disclaimer.
//  2. Redistributions in binary form must reproduce the above copyright
//     notice, this list of conditions and the following disclaimer in the
//     documentation and/or other materials provided with the distribution.
//  3. The names of the authors and copyright holders may not be used to
//     endorse or promote products derived from this software without
//     specific prior written permission.
//
//  IN NO EVENT SHALL DANIEL W. MCROBB BE LIABLE TO ANY PARTY FOR
//  DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES,
//  INCLUDING LOST PROFITS, ARISING OUT OF THE USE OF THIS SOFTWARE,
//  EVEN IF DANIEL W. MCROBB HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH
//  DAMAGE.
//
//  THE SOFTWARE PROVIDED HEREIN IS ON AN "AS IS" BASIS, AND
//  DANIEL W. MCROBB HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT,
//  UPDATES, ENHANCEMENTS, OR MODIFICATIONS. DANIEL W. MCROBB MAKES NO
//  REPRESENTATIONS AND EXTENDS NO WARRANTIES OF ANY KIND, EITHER
//  IMPLIED OR EXPRESS, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
//  WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE,
//  OR THAT THE USE OF THIS SOFTWARE WILL NOT INFRINGE ANY PATENT,
//  TRADEMARK OR OTHER RIGHTS.
//===========================================================================

//---------------------------------------------------------------------------
//!  \file DwmMcroverCurrentWeatherWidget.hh
//!  \author Daniel W. McRobb
//!  \brief NOT YET DOCUMENTED
//---------------------------------------------------------------------------

#ifndef _DWMMCROVERCURRENTWEATHERWIDGET_HH_
#define _DWMMCROVERCURRENTWEATHERWIDGET_HH_

#include <QFrame>
#include <QLabel>

#include "DwmMcweatherCurrentConditions.hh"

namespace Dwm {

  namespace Mcrover {

    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    class CurrentWeatherWidget
      : public QFrame
    {
      Q_OBJECT

    public:
      CurrentWeatherWidget(QWidget *parent = nullptr,
                           Qt::WindowFlags f = Qt::WindowFlags());
      QSize sizeHint() const override;

    public slots:
      void Populate(Mcweather::CurrentConditions wcc);

    protected:
      QLabel   *_stationLabel;
      QLabel   *_temperatureLabel;
      QLabel   *_humidityLabel;
      QLabel   *_pressureLabel;
      QLabel   *_dewpointLabel;
      QLabel   *_windSpeedLabel;
      QLabel   *_windChillOrHeatIndexLabel;
    };

    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    class CurrentWeatherWidgetPair
      : public QFrame
    {
      Q_OBJECT
      
    public:
      CurrentWeatherWidgetPair(QWidget *parent = nullptr,
                               Qt::WindowFlags f = Qt::WindowFlags());

    public slots:
      void Populate(int sn, Mcweather::CurrentConditions wcc);
      
    protected:
      CurrentWeatherWidget  *_first;
      CurrentWeatherWidget  *_second;
    };
    
  }  // namespace Mcrover

}  // namespace Dwm

#endif  // _DWMMCROVERCURRENTWEATHERWIDGET_HH_
