//===========================================================================
// @(#) $DwmPath: dwm/mcplex/mcrover/tags/mcrover-0.1.13/apps/qmcrover/DwmMcroverCalendarWidget.cc 10997 $
// @(#) $Id: DwmMcroverCalendarWidget.cc 10997 2020-08-27 05:34:16Z dwm $
//===========================================================================
//  Copyright (c) Daniel W. McRobb 2020
//  All rights reserved.
//
//  Redistribution and use in source and binary forms, with or without
//  modification, are permitted provided that the following conditions
//  are met:
//
//  1. Redistributions of source code must retain the above copyright
//     notice, this list of conditions and the following disclaimer.
//  2. Redistributions in binary form must reproduce the above copyright
//     notice, this list of conditions and the following disclaimer in the
//     documentation and/or other materials provided with the distribution.
//  3. The names of the authors and copyright holders may not be used to
//     endorse or promote products derived from this software without
//     specific prior written permission.
//
//  IN NO EVENT SHALL DANIEL W. MCROBB BE LIABLE TO ANY PARTY FOR
//  DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES,
//  INCLUDING LOST PROFITS, ARISING OUT OF THE USE OF THIS SOFTWARE,
//  EVEN IF DANIEL W. MCROBB HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH
//  DAMAGE.
//
//  THE SOFTWARE PROVIDED HEREIN IS ON AN "AS IS" BASIS, AND
//  DANIEL W. MCROBB HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT,
//  UPDATES, ENHANCEMENTS, OR MODIFICATIONS. DANIEL W. MCROBB MAKES NO
//  REPRESENTATIONS AND EXTENDS NO WARRANTIES OF ANY KIND, EITHER
//  IMPLIED OR EXPRESS, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
//  WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE,
//  OR THAT THE USE OF THIS SOFTWARE WILL NOT INFRINGE ANY PATENT,
//  TRADEMARK OR OTHER RIGHTS.
//===========================================================================

//---------------------------------------------------------------------------
//!  \file DwmMcroverCalendarWidget.cc
//!  \author Daniel W. McRobb
//!  \brief NOT YET DOCUMENTED
//---------------------------------------------------------------------------

#include <QVBoxLayout>

#include "DwmDateTime.hh"
#include "DwmSvnTag.hh"
#include "DwmMcroverCalendarWidget.hh"

static const Dwm::SvnTag svntag("@(#) $DwmPath: dwm/mcplex/mcrover/tags/mcrover-0.1.13/apps/qmcrover/DwmMcroverCalendarWidget.cc 10997 $");

namespace Dwm {

  namespace Mcrover {

    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    CalendarWidget::CalendarWidget(QWidget *parent, Qt::WindowFlags f)
        : QFrame(parent, f)
    {
      QVBoxLayout  *layout = new QVBoxLayout();
      layout->setAlignment(Qt::AlignHCenter|Qt::AlignTop);
      layout->setSpacing(0);
      
      _timeLabel = new QLabel("00:00");
      QFont  font = _timeLabel->font();
      font.setPointSize(56);
      _timeLabel->setFont(font);

      _dateLabel = new QLabel("Jan 01");
      font.setPointSize(28);
      _dateLabel->setFont(font);

      layout->addWidget(_timeLabel);
      layout->setAlignment(_timeLabel, Qt::AlignHCenter);
      layout->addWidget(_dateLabel);
      layout->setAlignment(_dateLabel, Qt::AlignHCenter);
      setLayout(layout);
    }
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    void CalendarWidget::Update()
    {
      TimeValue64  now(true);
      DateTime     dt(now);
      _timeLabel->setText(dt.Formatted("%k:%M").c_str());
      _dateLabel->setText(dt.Formatted("%a %b %e").c_str());
      return;
    }
    

  }  // namespace Mcrover

  
}  // namespace Dwm
