//===========================================================================
// @(#) $DwmPath: dwm/mcplex/mcrover/tags/mcrover-0.1.13/apps/mcroverd/DwmMcroverListenSockets.cc 11350 $
// @(#) $Id: DwmMcroverListenSockets.cc 11350 2020-12-08 01:01:10Z dwm $
//===========================================================================
//  Copyright (c) Daniel W. McRobb 2020
//  All rights reserved.
//
//  Redistribution and use in source and binary forms, with or without
//  modification, are permitted provided that the following conditions
//  are met:
//
//  1. Redistributions of source code must retain the above copyright
//     notice, this list of conditions and the following disclaimer.
//  2. Redistributions in binary form must reproduce the above copyright
//     notice, this list of conditions and the following disclaimer in the
//     documentation and/or other materials provided with the distribution.
//  3. The names of the authors and copyright holders may not be used to
//     endorse or promote products derived from this software without
//     specific prior written permission.
//
//  IN NO EVENT SHALL DANIEL W. MCROBB BE LIABLE TO ANY PARTY FOR
//  DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES,
//  INCLUDING LOST PROFITS, ARISING OUT OF THE USE OF THIS SOFTWARE,
//  EVEN IF DANIEL W. MCROBB HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH
//  DAMAGE.
//
//  THE SOFTWARE PROVIDED HEREIN IS ON AN "AS IS" BASIS, AND
//  DANIEL W. MCROBB HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT,
//  UPDATES, ENHANCEMENTS, OR MODIFICATIONS. DANIEL W. MCROBB MAKES NO
//  REPRESENTATIONS AND EXTENDS NO WARRANTIES OF ANY KIND, EITHER
//  IMPLIED OR EXPRESS, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
//  WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE,
//  OR THAT THE USE OF THIS SOFTWARE WILL NOT INFRINGE ANY PATENT,
//  TRADEMARK OR OTHER RIGHTS.
//===========================================================================

//---------------------------------------------------------------------------
//!  \file DwmMcroverListenSockets.cc
//!  \author Daniel W. McRobb
//!  \brief NOT YET DOCUMENTED
//---------------------------------------------------------------------------

#include "DwmSysLogger.hh"
#include "DwmMcroverListenSockets.hh"

namespace Dwm {

  namespace Mcrover {

    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    ListenSockets::ListenSockets(const Config & config)
        : _sockets()
    {
      for (const auto & addr : config.Service().Addresses()) {
        _sockets[addr] = ListenSocket(addr);
      }
    }
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    bool ListenSockets::Listen()
    {
      bool  rc = true;
      for (auto & s : _sockets) {
        if (! s.second.Listen()) {
          rc = false;
          Syslog(LOG_ERR, "Failed to listen on %s",
                 ((std::string)(s.first)).c_str());
        }
      }
      return rc;
    }
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    int ListenSockets::Accept(uint16_t msecsToWait, TCPAddress & clientAddr)
    {
      int  rc = -1;
      if (! _sockets.empty()) {
        struct timeval  timeout = { 0, msecsToWait * 1000 };
        fd_set  readFdSet;
        FD_ZERO(&readFdSet);
        bool    shouldSelect = false;
        for (auto & s : _sockets) {
          if (0 <= s.second.Descriptor()) {
            FD_SET(s.second.Descriptor(), &readFdSet);
            shouldSelect = true;
          }
        }
        if (shouldSelect) {
          if (select(FD_SETSIZE, &readFdSet, 0, 0, &timeout) > 0) {
            for (auto & s : _sockets) {
              if (FD_ISSET(s.second.Descriptor(), &readFdSet)) {
                rc = s.second.Accept(clientAddr);
                break;
              }
            }
          }
        }
      }
      
      return rc;
    }

    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    void ListenSockets::Close()
    {
      for (auto & s : _sockets) {
        s.second.Close();
      }
      return;
    }

  }  // namespace Mcrover

}  // namespace Dwm
