//===========================================================================
// @(#) $DwmPath: dwm/mcplex/mcpigdocomm/tags/mcpigdocomm-0.1.1/src/DwmPiGdoRequestMessage.cc 9758 $
// @(#) $Id: DwmPiGdoRequestMessage.cc 9758 2017-07-07 01:50:12Z dwm $
//===========================================================================
//  Copyright (c) Daniel W. McRobb 2016
//  All rights reserved.
//
//  Redistribution and use in source and binary forms, with or without
//  modification, are permitted provided that the following conditions
//  are met:
//
//  1. Redistributions of source code must retain the above copyright
//     notice, this list of conditions and the following disclaimer.
//  2. Redistributions in binary form must reproduce the above copyright
//     notice, this list of conditions and the following disclaimer in the
//     documentation and/or other materials provided with the distribution.
//  3. The names of the authors and copyright holders may not be used to
//     endorse or promote products derived from this software without
//     specific prior written permission.
//
//  IN NO EVENT SHALL DANIEL W. MCROBB BE LIABLE TO ANY PARTY FOR
//  DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES,
//  INCLUDING LOST PROFITS, ARISING OUT OF THE USE OF THIS SOFTWARE,
//  EVEN IF DANIEL W. MCROBB HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH
//  DAMAGE.
//
//  THE SOFTWARE PROVIDED HEREIN IS ON AN "AS IS" BASIS, AND
//  DANIEL W. MCROBB HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT,
//  UPDATES, ENHANCEMENTS, OR MODIFICATIONS. DANIEL W. MCROBB MAKES NO
//  REPRESENTATIONS AND EXTENDS NO WARRANTIES OF ANY KIND, EITHER
//  IMPLIED OR EXPRESS, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
//  WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE,
//  OR THAT THE USE OF THIS SOFTWARE WILL NOT INFRINGE ANY PATENT,
//  TRADEMARK OR OTHER RIGHTS.
//===========================================================================

//---------------------------------------------------------------------------
//!  \file DwmPiGdoRequestMessage.cc
//!  \brief Dwm::Pi::Gdo::RequestMessage implementation
//!  \author Daniel W. McRobb \link mailto:dwm@mcplex.net \endlink
//---------------------------------------------------------------------------

extern "C" {
  #include <unistd.h>
}

#include "DwmIO.hh"
#include "DwmSvnTag.hh"
#include "DwmAuthSymCryptoMessage.hh"
#include "DwmPiGdoRequestMessage.hh"

static const Dwm::SvnTag svntag("@(#) $DwmPath: dwm/mcplex/mcpigdocomm/tags/mcpigdocomm-0.1.1/src/DwmPiGdoRequestMessage.cc 9758 $");

using namespace std;

namespace Dwm {

  namespace Pi {

    namespace Gdo {

      //----------------------------------------------------------------------
      //!  
      //----------------------------------------------------------------------
      RequestMessage::RequestMessage()
          : _value()
      {}

      //----------------------------------------------------------------------
      //!  
      //----------------------------------------------------------------------
      RequestMessage::RequestMessage(RequestEnum request,
                                     const string & requestData)
      {
        _value.clear();
        switch (request) {
          case e_requestStatus:
            _value["type"] = "status";
            break;
          case e_requestOpenDoor:
            _value["type"] = "openDoor";
            _value["door"] = requestData;
            break;
          case e_requestCloseDoor:
            _value["type"] = "closeDoor";
            _value["door"] = requestData;
            break;
          case e_requestGetConfig:
            _value["type"] = "getConfig";
            break;
          case e_requestActivate:
            _value["type"] = "activation";
            _value["door"] = requestData;
            _value["action"] = true;
            break;
          case e_requestGetMcastKey:
            _value["type"] = "getMcastKey";
            break;
          default:
            break;
        }
      }
      
      //----------------------------------------------------------------------
      //!  
      //----------------------------------------------------------------------
      bool RequestMessage::Read(int fd, const string & secret)
      {
        bool  rc = false;
        if (fd >= 0) {
          _value.clear();
          Auth::SymCrypto::Message  msg(secret);
          if (msg.Read(fd) > 0) {
            Json::Reader  jsonReader;
            rc = jsonReader.parse(msg.Value(), _value);
          }
        }
        return rc;
      }
          
      //----------------------------------------------------------------------
      //!  
      //----------------------------------------------------------------------
      bool RequestMessage::Write(int fd, const string & secret) const
      {
        bool  rc = false;
        if (fd >= 0) {
          Json::FastWriter  fw;
          Auth::SymCrypto::Message  msg(secret, fw.write(_value));
          if (msg.Write(fd) == msg.StreamedLength()) {
            rc = true;
          }
        }
        return rc;
      }

      //----------------------------------------------------------------------
      //!  
      //----------------------------------------------------------------------
      const Json::Value & RequestMessage::Json() const
      {
        return _value;
      }

      
    }  // namespace Gdo

  }  // namespace Pi

}  // namespace Dwm
