//===========================================================================
// @(#) $DwmPath: dwm/mcplex/mcpigdocomm/tags/mcpigdocomm-0.1.1/apps/mcpigdoc/mcpigdoc.cc 9766 $
// @(#) $Id: mcpigdoc.cc 9766 2017-07-07 03:08:45Z dwm $
//===========================================================================
//  Copyright (c) Daniel W. McRobb 2016
//  All rights reserved.
//
//  Redistribution and use in source and binary forms, with or without
//  modification, are permitted provided that the following conditions
//  are met:
//
//  1. Redistributions of source code must retain the above copyright
//     notice, this list of conditions and the following disclaimer.
//  2. Redistributions in binary form must reproduce the above copyright
//     notice, this list of conditions and the following disclaimer in the
//     documentation and/or other materials provided with the distribution.
//  3. The names of the authors and copyright holders may not be used to
//     endorse or promote products derived from this software without
//     specific prior written permission.
//
//  IN NO EVENT SHALL DANIEL W. MCROBB BE LIABLE TO ANY PARTY FOR
//  DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES,
//  INCLUDING LOST PROFITS, ARISING OUT OF THE USE OF THIS SOFTWARE,
//  EVEN IF DANIEL W. MCROBB HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH
//  DAMAGE.
//
//  THE SOFTWARE PROVIDED HEREIN IS ON AN "AS IS" BASIS, AND
//  DANIEL W. MCROBB HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT,
//  UPDATES, ENHANCEMENTS, OR MODIFICATIONS. DANIEL W. MCROBB MAKES NO
//  REPRESENTATIONS AND EXTENDS NO WARRANTIES OF ANY KIND, EITHER
//  IMPLIED OR EXPRESS, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
//  WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE,
//  OR THAT THE USE OF THIS SOFTWARE WILL NOT INFRINGE ANY PATENT,
//  TRADEMARK OR OTHER RIGHTS.
//===========================================================================

//---------------------------------------------------------------------------
//!  \file mcpigdoc.cc
//!  \brief NOT YET DOCUMENTED
//---------------------------------------------------------------------------

extern "C" {
  #include <sys/types.h>
  #include <sys/socket.h>
  #include <netinet/in.h>
  #include <netinet/tcp.h>
  #include <arpa/inet.h>
  #include <netdb.h>
  #include <pwd.h>
  #include <unistd.h>
}

#include <fstream>
#include <string>

#include "DwmAuth.hh"
#include "DwmAuthPeerAuthenticator.hh"
#include "DwmIO.hh"
#include "DwmOptArgs.hh"
#include "DwmSocket.hh"
#include "DwmSvnTag.hh"
#include "DwmSysLogger.hh"
#include "DwmPiGdoRequestMessage.hh"
#include "DwmPiGdoResponseMessage.hh"

static const Dwm::SvnTag svntag("@(#) $DwmPath: dwm/mcplex/mcpigdocomm/tags/mcpigdocomm-0.1.1/apps/mcpigdoc/mcpigdoc.cc 9766 $");

using namespace std;
using namespace Dwm;
using namespace Dwm::Pi;

//----------------------------------------------------------------------------
//!  
//----------------------------------------------------------------------------
static bool Authenticate(Dwm::Socket & s, string & agreedKey)
{
  bool  rc = false;
  Auth::PeerAuthenticator  peerAuth("", "");
  string theirId;
  return peerAuth.Authenticate(s, theirId, agreedKey);
}

//----------------------------------------------------------------------------
//!  
//----------------------------------------------------------------------------
string RequestResponse(Socket & s, const string & agreedKey,
                       const Gdo::RequestMessage & request)
{
  string                rc;
  Gdo::ResponseMessage  response;
  Json::FastWriter      jfw;
  if (request.Write(s, agreedKey)) {
    if (response.Read(s, agreedKey)) {
      rc = jfw.write(response.Json());
    }
    else {
      Syslog(LOG_ERR, "Failed to read server response");
    }
  }
  else {
    Syslog(LOG_ERR, "Failed to write server request");
  }
  return rc;
}

//----------------------------------------------------------------------------
//!  
//----------------------------------------------------------------------------
bool Connect(const string & host, uint16_t portNum, Socket & s)
{
  bool  rc = false;
  struct hostent  *hostEntry = gethostbyname(host.c_str());
  if (! hostEntry) {
    cerr << "Host '" << host << "' not found.\n";
    exit(1);
  }
  
  if (s.Open(PF_INET, SOCK_STREAM, 0)) {
    struct sockaddr_in  servAddr;
    memset(&servAddr, 0, sizeof(servAddr));
#ifndef __linux__
    servAddr.sin_len = sizeof(servAddr);
#endif
    servAddr.sin_family = AF_INET;
    servAddr.sin_port = htons(portNum);
    servAddr.sin_addr.s_addr = *(in_addr_t *)hostEntry->h_addr_list[0];
    if (s.Connect(servAddr)) {
      int  noDelay = 1;
      s.Setsockopt(IPPROTO_TCP, TCP_NODELAY, &noDelay, sizeof(noDelay));
      rc = true;
    }
    else {
      cerr << "Failed to connect to " << inet_ntoa(servAddr.sin_addr)
           << ':' << portNum << endl;
    }
  }
  return rc;
}

//----------------------------------------------------------------------------
//!  
//----------------------------------------------------------------------------
bool GetConfig(Socket & s, const string & agreedKey)
{
  bool  rc = false;
  Gdo::RequestMessage   request(Gdo::RequestMessage::e_requestGetConfig);
  string  resp = RequestResponse(s, agreedKey, request);
  if (! resp.empty()) {
    cout << resp << '\n';
    rc = true;
  }
  return rc;
}

//----------------------------------------------------------------------------
//!  
//----------------------------------------------------------------------------
bool GetStatus(Socket & s, const string & agreedKey)
{
  bool  rc = false;
  Gdo::RequestMessage   request(Gdo::RequestMessage::e_requestStatus);
  string  resp = RequestResponse(s, agreedKey, request);
  if (! resp.empty()) {
    cout << resp << '\n';
    rc = true;
  }
  return rc;
}

//----------------------------------------------------------------------------
//!  
//----------------------------------------------------------------------------
static void Usage(const string & argv0)
{
  cerr << "Usage: " << argv0 << " status hostname\n"
       << "       " << argv0 << " config hostname\n";
  return;
}

//----------------------------------------------------------------------------
//!  
//----------------------------------------------------------------------------
int main(int argc, char *argv[])
{
  int      rc = 1;
  OptArgs  optargs;
  optargs.AddOptArg("p:", "port", false, "2121", "TCP port");
  optargs.AddNormalArg("(status|config)", true);
  optargs.AddNormalArg("host", true);
  int  nextArg = optargs.Parse(argc, argv);

  if (argc < 2) {
    optargs.Usage(argv[0]);
    exit(1);
  }
  uint32_t  portArg = stoul(optargs.Get<string>('p'));
  if (portArg > 65535) {
    cerr << "Invalid port number " << portArg << endl;
    optargs.Usage(argv[0]);
    exit(1);
  }
  uint16_t  portNum = (uint16_t)portArg;
  
  SysLogger::Open("mcpigdoc", LOG_PERROR, LOG_USER);
  SysLogger::MinimumPriority("info");

  string  agreedKey;
  
  if (string(argv[nextArg]) == "status") {
    if (argc > ++nextArg) {
      Socket  s;
      if (Connect(argv[nextArg], portNum, s)) {
        if (Authenticate(s, agreedKey)) {
          if (GetStatus(s, agreedKey)) {
            rc = 0;
          }
        }
      }
      else {
        Syslog(LOG_ERR, "Connect failed\n");
      }
    }
    else {
      Usage(argv[0]);
      exit(1);
    }
  }
  else if (string(argv[nextArg]) == "config") {
    if (argc > ++nextArg) {
      Socket  s;
      if (Connect(argv[nextArg], portNum, s)) {
        if (Authenticate(s, agreedKey)) {
          if (GetConfig(s, agreedKey)) {
            rc = 0;
          }
        }
      }
    }
    else {
      Usage(argv[0]);
      exit(1);
    }
  }
  else {
    Usage(argv[0]);
    exit(1);
  }

  return rc;
}
