//===========================================================================
// @(#) $Name:$
// @(#) $Id: DwmMcBlockMailLogParser.cc 8913 2017-03-27 09:57:46Z dwm $
//===========================================================================
//  Copyright (c) Daniel W. McRobb 2015, 2017
//  All rights reserved.
//
//  Redistribution and use in source and binary forms, with or without
//  modification, are permitted provided that the following conditions
//  are met:
//
//  1. Redistributions of source code must retain the above copyright
//     notice, this list of conditions and the following disclaimer.
//  2. Redistributions in binary form must reproduce the above copyright
//     notice, this list of conditions and the following disclaimer in the
//     documentation and/or other materials provided with the distribution.
//  3. The names of the authors and copyright holders may not be used to
//     endorse or promote products derived from this software without
//     specific prior written permission.
//
//  IN NO EVENT SHALL DANIEL W. MCROBB BE LIABLE TO ANY PARTY FOR
//  DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES,
//  INCLUDING LOST PROFITS, ARISING OUT OF THE USE OF THIS SOFTWARE,
//  EVEN IF DANIEL W. MCROBB HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH
//  DAMAGE.
//
//  THE SOFTWARE PROVIDED HEREIN IS ON AN "AS IS" BASIS, AND
//  DANIEL W. MCROBB HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT,
//  UPDATES, ENHANCEMENTS, OR MODIFICATIONS. DANIEL W. MCROBB MAKES NO
//  REPRESENTATIONS AND EXTENDS NO WARRANTIES OF ANY KIND, EITHER
//  IMPLIED OR EXPRESS, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
//  WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE,
//  OR THAT THE USE OF THIS SOFTWARE WILL NOT INFRINGE ANY PATENT,
//  TRADEMARK OR OTHER RIGHTS.
//===========================================================================

//---------------------------------------------------------------------------
//!  \file DwmMcBlockMailLogParser.cc
//!  \brief NOT YET DOCUMENTED
//---------------------------------------------------------------------------

#include <fstream>

#include "DwmMcBlockMailLogParser.hh"

using namespace std;

namespace Dwm {

  namespace McBlock {

    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    const vector<regex>  MailLogParser::_regexes = {
      regex("dovecot.*pam\\(.+,"
            "([0-9]+\\.[0-9]+\\.[0-9]+\\.[0-9]+)\\): pam_autenticate\\(\\) failed: authentication error.+",
            regex::ECMAScript|regex::optimize),
      regex("authentication failure: checkpass failed,.* \\["
            "([0-9]+\\.[0-9]+\\.[0-9]+\\.[0-9]+)\\]",
            regex::ECMAScript|regex::optimize),
      regex("auth failed, [0-9]+ attempts\\): .* rip=([0-9]+\\.[0-9]+\\.[0-9]+\\.[0-9]+),",
            regex::ECMAScript|regex::optimize),
      regex("imap-login: Disconnected \\(no auth attempts\\): rip="
            "([0-9]+\\.[0-9]+\\.[0-9]+\\.[0-9]+),",
            regex::ECMAScript|regex::optimize)
    };
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    MailLogParser::MailLogParser()
        : _matches()
    {}
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    bool MailLogParser::Parse(const string & fileName)
    {
      bool  rc = false;
      istream  *is = &cin;
      ifstream  fis;
      if (fileName != "-") {
        fis = ifstream(fileName.c_str());
        is = &fis;
      }
      if (is) {
        string  line;
        while (getline(*is, line, '\n')) {
          for (auto r : _regexes) {
            smatch  sm;
            if (regex_search(line, sm, r)) {
              if (sm.size() > 1) {
                Dwm::Ipv4Address  addr(sm[1].str());
                ++_matches[addr];
              }
            }
          }
        }
        if (is != &cin) {
          fis.close();
        }
        rc = true;
      }
      return rc;
    }
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    vector<pair<Ipv4Prefix,uint64_t> >
    MailLogParser::SortedPrefixes(uint8_t masklen) const
    {
      vector<pair<Ipv4Prefix,uint64_t> >  rc;
      map<Ipv4Prefix,uint64_t>  pm;
      for (auto l : _matches) {
        Ipv4Prefix  pfx(l.first, masklen);
        pm[pfx] += l.second;
      }
      for (auto m : pm) {
        rc.push_back(m);
      }
      sort(rc.begin(), rc.end(),
           [&](const pair<Ipv4Prefix,uint64_t> & p1,
               const pair<Ipv4Prefix,uint64_t> & p2)
           { return p1.second > p2.second; });
      return rc;
    }
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    vector<pair<Ipv4Address,uint64_t> >
    MailLogParser::SortedHosts() const
    {
      vector<pair<Ipv4Address,uint64_t> >  rc;
      for (auto l : _matches) {
        rc.push_back(l);
      }
      sort(rc.begin(), rc.end(),
           [&](const pair<Ipv4Address,uint64_t> & p1,
               const pair<Ipv4Address,uint64_t> & p2)
           { return p1.second > p2.second; });
      return rc;
    }
    
    
  }  // namespace McBlock

}  // namespace Dwm
