//===========================================================================
// @(#) $Name:$
// @(#) $Id: TestIpv4CountryDb.cc 9409 2017-06-03 03:53:02Z dwm $
//===========================================================================
//  Copyright (c) Daniel W. McRobb 2017
//  All rights reserved.
//
//  Redistribution and use in source and binary forms, with or without
//  modification, are permitted provided that the following conditions
//  are met:
//
//  1. Redistributions of source code must retain the above copyright
//     notice, this list of conditions and the following disclaimer.
//  2. Redistributions in binary form must reproduce the above copyright
//     notice, this list of conditions and the following disclaimer in the
//     documentation and/or other materials provided with the distribution.
//  3. The names of the authors and copyright holders may not be used to
//     endorse or promote products derived from this software without
//     specific prior written permission.
//
//  IN NO EVENT SHALL DANIEL W. MCROBB BE LIABLE TO ANY PARTY FOR
//  DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES,
//  INCLUDING LOST PROFITS, ARISING OUT OF THE USE OF THIS SOFTWARE,
//  EVEN IF DANIEL W. MCROBB HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH
//  DAMAGE.
//
//  THE SOFTWARE PROVIDED HEREIN IS ON AN "AS IS" BASIS, AND
//  DANIEL W. MCROBB HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT,
//  UPDATES, ENHANCEMENTS, OR MODIFICATIONS. DANIEL W. MCROBB MAKES NO
//  REPRESENTATIONS AND EXTENDS NO WARRANTIES OF ANY KIND, EITHER
//  IMPLIED OR EXPRESS, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
//  WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE,
//  OR THAT THE USE OF THIS SOFTWARE WILL NOT INFRINGE ANY PATENT,
//  TRADEMARK OR OTHER RIGHTS.
//===========================================================================

//---------------------------------------------------------------------------
//!  \file TestIpv4CountryDb.cc
//!  \brief Unit tests for Dwm::Ipv4CountryDb class
//---------------------------------------------------------------------------

#include "DwmSvnTag.hh"
#include "DwmUnitAssert.hh"
#include "DwmIpv4CountryDb.hh"

using namespace std;
using namespace Dwm;

//----------------------------------------------------------------------------
//!  
//----------------------------------------------------------------------------
int main(int argc, char *argv[])
{
  Dwm::TimeValue64  now(true);

  typedef  pair<Ipv4Prefix,Ipv4CountryDbValue>  dbPair_t;
  
  vector<dbPair_t>  prefixes = {
    dbPair_t(Ipv4Prefix("10.0.0.0/8"),   Ipv4CountryDbValue("US", now)),
    dbPair_t(Ipv4Prefix("10.1.0.0/16"),  Ipv4CountryDbValue("CN", now)),
    dbPair_t(Ipv4Prefix("10.1.1.0/24"),  Ipv4CountryDbValue("GB", now)),
    dbPair_t(Ipv4Prefix("10.1.1.10/30"), Ipv4CountryDbValue("FR", now))
  };

  remove("./ipv4country.db");
  
  Ipv4CountryDb  ipcntryDb("./ipv4country.db");
  for (auto p : prefixes) {
    UnitAssert(((RDAP::Ipv4Routes<Ipv4CountryDbValue> &)ipcntryDb).Add(p.first,
                                                                       p.second));
  }

  for (auto p : prefixes) {
    Ipv4CountryDbValue  found;
    UnitAssert(ipcntryDb.Find(p.first, found));
    UnitAssert(found == p.second);
  }

  UnitAssert(ipcntryDb.Save());
  UnitAssert(ipcntryDb.Reload());

  for (auto p : prefixes) {
    Ipv4CountryDbValue  found;
    UnitAssert(ipcntryDb.Find(p.first, found));
    UnitAssert(found == p.second);
    dbPair_t  longest;
    UnitAssert(ipcntryDb.FindLongest(p.first.Network(), longest));
    UnitAssert(longest.first == p.first);
    UnitAssert(longest.second.Code() == p.second.Code());
  }

  vector<dbPair_t>  matches;
  int  i = prefixes.size() - 1;
  for ( ; i >= 0; --i) {
    UnitAssert(ipcntryDb.Find(prefixes[i].first.Network(), matches));
    UnitAssert(matches.size() == (i + 1));
    for (int j = 0; j < matches.size(); ++j) {
      UnitAssert(matches[j].first == prefixes[i-j].first);
      UnitAssert(matches[j].second == prefixes[i-j].second);
    }
  }
  
  remove("./ipv4country.db");

  if (Assertions::Total().Failed() > 0) {
    Assertions::Print(cerr, true);
    return(1);
  }
  else {
    cout << Assertions::Total() << " passed\n";
  }
}

