//===========================================================================
// @(#) $Name:$
// @(#) $Id: DwmRDAPResponseMessage.cc 12118 2022-12-11 04:35:10Z dwm $
//===========================================================================
//  Copyright (c) Daniel W. McRobb 2017, 2022
//  All rights reserved.
//
//  Redistribution and use in source and binary forms, with or without
//  modification, are permitted provided that the following conditions
//  are met:
//
//  1. Redistributions of source code must retain the above copyright
//     notice, this list of conditions and the following disclaimer.
//  2. Redistributions in binary form must reproduce the above copyright
//     notice, this list of conditions and the following disclaimer in the
//     documentation and/or other materials provided with the distribution.
//  3. The names of the authors and copyright holders may not be used to
//     endorse or promote products derived from this software without
//     specific prior written permission.
//
//  IN NO EVENT SHALL DANIEL W. MCROBB BE LIABLE TO ANY PARTY FOR
//  DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES,
//  INCLUDING LOST PROFITS, ARISING OUT OF THE USE OF THIS SOFTWARE,
//  EVEN IF DANIEL W. MCROBB HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH
//  DAMAGE.
//
//  THE SOFTWARE PROVIDED HEREIN IS ON AN "AS IS" BASIS, AND
//  DANIEL W. MCROBB HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT,
//  UPDATES, ENHANCEMENTS, OR MODIFICATIONS. DANIEL W. MCROBB MAKES NO
//  REPRESENTATIONS AND EXTENDS NO WARRANTIES OF ANY KIND, EITHER
//  IMPLIED OR EXPRESS, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
//  WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE,
//  OR THAT THE USE OF THIS SOFTWARE WILL NOT INFRINGE ANY PATENT,
//  TRADEMARK OR OTHER RIGHTS.
//===========================================================================

//---------------------------------------------------------------------------
//!  \file DwmRDAPResponseMessage.cc
//!  \brief Dwm::RDAP::ResponseMessage class implementation
//---------------------------------------------------------------------------

#include "DwmStreamIO.hh"
#include "DwmSvnTag.hh"
#include "DwmRDAPResponseMessage.hh"

static const Dwm::SvnTag svntag("@(#) $DwmPath: dwm/libDwmRDAP/trunk/src/DwmRDAPResponseMessage.cc 12118 $");

using namespace std;

namespace Dwm {

  namespace RDAP {

    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    ResponseMessage::ResponseMessage()
        : _value()
    {}
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    ResponseMessage::ResponseMessage(const nlohmann::json & value)
        : _value(value)
    {}

    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    ResponseMessage::ResponseMessage(const nlohmann::json && value)
        : _value(std::move(value))
    {}

    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    const nlohmann::json & ResponseMessage::Json() const
    {
      return _value;
    }
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    const nlohmann::json & ResponseMessage::Json(const nlohmann::json & value)
    {
      _value = value;
      return _value;
    }
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    std::istream & ResponseMessage::Read(std::istream & is)
    {
      _value.clear();
      _value = "";
      if (is) {
        _value = nlohmann::json::parse(is, nullptr, false);
      }
      return is;
    }
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    std::ostream & ResponseMessage::Write(std::ostream & os) const
    {
      if (os) {
        os << _value.dump();
      }
      return os;
    }

    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    bool ResponseMessage::Read(Credence::Peer & peer)
    {
      bool  rc = false;
      _value.clear();
      _value = "";
      std::string  s;
      if (peer.Receive(s)) {
        _value = nlohmann::json::parse(s, nullptr, false);
        rc = (! _value.is_discarded());
      }
      return rc;
    }
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    bool ResponseMessage::Write(Credence::Peer & peer) const
    {
      std::string  s = _value.dump();
      return peer.Send(s);
    }
    
  }  // namespace RDAP

}  // namespace Dwm
