extern "C" {
  #include <unistd.h>
}

#include "DwmSysLogger.hh"
#include "DwmThreadQueue.hh"

#include "DwmPiRotaryEncoderReader.hh"

using namespace std;
using namespace Dwm;

//----------------------------------------------------------------------------
//!  
//----------------------------------------------------------------------------
class MyWatcher
  : public Pi::RotaryEncoderReaderWatcher
{
public:
  MyWatcher()
      : _moveQueue()
  {}
  
  void EncoderMovedClockwise()
  {
    _moveQueue.PushBack(true);
  }

  void EncoderMovedCounterClockwise()
  {
    _moveQueue.PushBack(false);
  }

  Thread::Queue<bool> & Moves()
  {
    return _moveQueue;
  }
  
private:
  Thread::Queue<bool>  _moveQueue;
};

//----------------------------------------------------------------------------
//!  
//----------------------------------------------------------------------------
int main(int argc, char *argv[])
{
  SysLogger::Open("TestPiRotaryEncoderReader", LOG_PERROR, LOG_USER);

  MyWatcher  encoderWatcher;

  Pi::RotaryEncoderReader  rer("gpiorotenc1");
  rer.AddWatcher(&encoderWatcher);
  
  rer.Start();

  for (;;) {
    if (encoderWatcher.Moves().TimedWaitForNotEmpty(chrono::seconds(1))) {
      bool  value;
      if (encoderWatcher.Moves().PopFront(value)) {
        if (value) {
          cerr << "Encoder moved clockwise\n";
        }
        else {
          cerr << "Encoder moved counterclockwise\n";
        }
      }
    }
    else {
      cerr << "Encoder is stopped\n";
    }
  }

  return 0;
}
