//===========================================================================
// @(#) $Name$
// @(#) $Id: TestPiPinReader.cc 995 2016-03-03 06:05:38Z dwm $
//===========================================================================
//  Copyright (c) Daniel W. McRobb 2016
//  All rights reserved.
//
//  Redistribution and use in source and binary forms, with or without
//  modification, are permitted provided that the following conditions
//  are met:
//
//  1. Redistributions of source code must retain the above copyright
//     notice, this list of conditions and the following disclaimer.
//  2. Redistributions in binary form must reproduce the above copyright
//     notice, this list of conditions and the following disclaimer in the
//     documentation and/or other materials provided with the distribution.
//  3. The names of the authors and copyright holders may not be used to
//     endorse or promote products derived from this software without
//     specific prior written permission.
//
//  IN NO EVENT SHALL DANIEL W. MCROBB BE LIABLE TO ANY PARTY FOR
//  DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES,
//  INCLUDING LOST PROFITS, ARISING OUT OF THE USE OF THIS SOFTWARE,
//  EVEN IF DANIEL W. MCROBB HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH
//  DAMAGE.
//
//  THE SOFTWARE PROVIDED HEREIN IS ON AN "AS IS" BASIS, AND
//  DANIEL W. MCROBB HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT,
//  UPDATES, ENHANCEMENTS, OR MODIFICATIONS. DANIEL W. MCROBB MAKES NO
//  REPRESENTATIONS AND EXTENDS NO WARRANTIES OF ANY KIND, EITHER
//  IMPLIED OR EXPRESS, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
//  WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE,
//  OR THAT THE USE OF THIS SOFTWARE WILL NOT INFRINGE ANY PATENT,
//  TRADEMARK OR OTHER RIGHTS.
//===========================================================================

//---------------------------------------------------------------------------
//!  \file TestPiPinReader.cc
//!  \brief NOT YET DOCUMENTED
//---------------------------------------------------------------------------

extern "C" {
  #include <unistd.h>
}

#include "DwmUnitAssert.hh"

#include "DwmPiPinReader.hh"

using namespace std;
using namespace Dwm;

//----------------------------------------------------------------------------
//!  
//----------------------------------------------------------------------------
class MyWatcher
  : public Pi::PinWatcher
{
public:
  MyWatcher()
      : _pinValue(0xFF)
  {
  }
  
  void PinWentLow()
  {
    _pinValue = 0;
  }
  
  void PinWentHigh()
  {
    _pinValue = 1;
  }

  uint8_t PinValue()
  {
    return _pinValue;
  }
  
private:
  uint8_t  _pinValue;
};

//----------------------------------------------------------------------------
//!  
//----------------------------------------------------------------------------
int main(int argc, char *argv[])
{
  Pi::GpioDevice  gpioDev(0);
  Pi::GpioPin     pin16(gpioDev, 16);
  pin16.Direction(Pi::GpioPin::e_directionOutput);
  
  Pi::PinReader   pinReader(pin16);
  UnitAssert(pinReader.State() == &Pi::PinReader::Initial);
  MyWatcher      watcher;
  pinReader.AddWatcher(&watcher);
  UnitAssert(watcher.PinValue() == 0xFF);
  
  pinReader.Start(20);
  
  pin16.Value(1);
  usleep(100000);
  UnitAssert(pinReader.State() == &Pi::PinReader::High);
  UnitAssert(watcher.PinValue() == 1);

  pin16.Value(0);
  usleep(100000);
  UnitAssert(pinReader.State() == &Pi::PinReader::Low);
  UnitAssert(watcher.PinValue() == 0);

  pinReader.RemoveWatcher(&watcher);
  pin16.Value(1);
  usleep(100000);
  UnitAssert(pinReader.State() == &Pi::PinReader::High);
  UnitAssert(watcher.PinValue() == 0);

  pin16.Value(0);
  usleep(100000);
  UnitAssert(pinReader.State() == &Pi::PinReader::Low);
  UnitAssert(watcher.PinValue() == 0);

  pinReader.Stop();
  UnitAssert(pinReader.State() == &Pi::PinReader::Initial);
  UnitAssert(watcher.PinValue() == 0);

  int rc = 1;
  if (Assertions::Total().Failed() == 0) {
    std::cout << Assertions::Total() << " passed" << std::endl;
    rc = 0;
  }
  else {
    Assertions::Print(std::cerr, true);
    rc = 1;
  }

  return rc;
}
