//===========================================================================
// @(#) $Name$
// @(#) $Id: TestPiGpio.cc 985 2016-02-28 06:03:01Z dwm $
//===========================================================================
//  Copyright (c) Daniel W. McRobb 2016
//  All rights reserved.
//
//  Redistribution and use in source and binary forms, with or without
//  modification, are permitted provided that the following conditions
//  are met:
//
//  1. Redistributions of source code must retain the above copyright
//     notice, this list of conditions and the following disclaimer.
//  2. Redistributions in binary form must reproduce the above copyright
//     notice, this list of conditions and the following disclaimer in the
//     documentation and/or other materials provided with the distribution.
//  3. The names of the authors and copyright holders may not be used to
//     endorse or promote products derived from this software without
//     specific prior written permission.
//
//  IN NO EVENT SHALL DANIEL W. MCROBB BE LIABLE TO ANY PARTY FOR
//  DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES,
//  INCLUDING LOST PROFITS, ARISING OUT OF THE USE OF THIS SOFTWARE,
//  EVEN IF DANIEL W. MCROBB HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH
//  DAMAGE.
//
//  THE SOFTWARE PROVIDED HEREIN IS ON AN "AS IS" BASIS, AND
//  DANIEL W. MCROBB HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT,
//  UPDATES, ENHANCEMENTS, OR MODIFICATIONS. DANIEL W. MCROBB MAKES NO
//  REPRESENTATIONS AND EXTENDS NO WARRANTIES OF ANY KIND, EITHER
//  IMPLIED OR EXPRESS, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
//  WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE,
//  OR THAT THE USE OF THIS SOFTWARE WILL NOT INFRINGE ANY PATENT,
//  TRADEMARK OR OTHER RIGHTS.
//===========================================================================

//---------------------------------------------------------------------------
//!  \file TestPiGpio.cc
//!  \brief NOT YET DOCUMENTED
//---------------------------------------------------------------------------

#include "DwmUnitAssert.hh"

#include "DwmPiGpio.hh"

using namespace Dwm;

//----------------------------------------------------------------------------
//!  
//----------------------------------------------------------------------------
static void TestInput(Pi::GpioDevice & gpioDev)
{
  Pi::GpioPin  pin4(gpioDev, 4);
  UnitAssert(pin4.Name("encoderChannelA"));
  UnitAssert(pin4.Name() == "encoderChannelA");

  UnitAssert(pin4.Direction(Pi::GpioPin::e_directionInput));
  UnitAssert(pin4.Direction() == Pi::GpioPin::e_directionInput);

  for (int i = 0; i < 2; ++i) {
    UnitAssert(pin4.Pull(Pi::GpioPin::e_pullDown));
    UnitAssert(pin4.Pull() == Pi::GpioPin::e_pullDown);
    
    UnitAssert(pin4.Pull(Pi::GpioPin::e_pullUp));
    UnitAssert(pin4.Pull() == Pi::GpioPin::e_pullUp);

    UnitAssert(pin4.Pull(Pi::GpioPin::e_pullNone));
    UnitAssert(pin4.Pull() == Pi::GpioPin::e_pullNone);
  }

#if 0
  //  Underlying functionality for these is not implemented in FreeBSD yet.
  UnitAssert(pin4.InvertInput(true));
  UnitAssert(pin4.InvertInput());
  UnitAssert(pin4.InvertInput(false));
  UnitAssert(! pin4.InvertInput());
#endif

  return;
}

//----------------------------------------------------------------------------
//!  
//----------------------------------------------------------------------------
static void TestOutput(Pi::GpioDevice & gpioDev)
{
  Pi::GpioPin  pin16(gpioDev, 16);

  UnitAssert(pin16.Direction(Pi::GpioPin::e_directionOutput));
  UnitAssert(pin16.Direction() == Pi::GpioPin::e_directionOutput);

  UnitAssert(pin16.Value(true));
  UnitAssert(pin16.Value());
  UnitAssert(pin16.Value(false));
  UnitAssert(! pin16.Value());

  UnitAssert(pin16.Toggle());
  UnitAssert(pin16.Value());
  UnitAssert(pin16.Toggle());
  UnitAssert(! pin16.Value());

#if 0
  //  Underlying functionality for these is not implemented in FreeBSD yet.
  UnitAssert(pin16.InvertOutput(true));
  UnitAssert(pin16.InvertOutput());
  UnitAssert(pin16.InvertOutput(false));
  UnitAssert(! pin16.InvertOutput());
#endif

  return;
}

//----------------------------------------------------------------------------
//!  
//----------------------------------------------------------------------------
int main(int argc, char *argv[])
{
  Pi::GpioDevice  gpioDev;

  UnitAssert(gpioDev.Handle() >= 0);

  TestInput(gpioDev);
  TestOutput(gpioDev);
  
  int rc = 1;
  if (Assertions::Total().Failed() == 0) {
    std::cout << Assertions::Total() << " passed" << std::endl;
    rc = 0;
  }
  else {
    Assertions::Print(std::cerr, true);
    rc = 1;
  }
  
  return rc;
}


