//===========================================================================
// @(#) $DwmPath: dwm/libDwmPi/tags/libDwmPi-0.1.0/src/DwmPiPinDebouncer.cc 8746 $
// @(#) $Id: DwmPiPinDebouncer.cc 8746 2016-07-31 01:44:29Z dwm $
//===========================================================================
//  Copyright (c) Daniel W. McRobb 2009, 2016
//  All rights reserved.
//
//  Redistribution and use in source and binary forms, with or without
//  modification, are permitted provided that the following conditions
//  are met:
//
//  1. Redistributions of source code must retain the above copyright
//     notice, this list of conditions and the following disclaimer.
//  2. Redistributions in binary form must reproduce the above copyright
//     notice, this list of conditions and the following disclaimer in the
//     documentation and/or other materials provided with the distribution.
//  3. The names of the authors and copyright holders may not be used to
//     endorse or promote products derived from this software without
//     specific prior written permission.
//
//  IN NO EVENT SHALL DANIEL W. MCROBB BE LIABLE TO ANY PARTY FOR
//  DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES,
//  INCLUDING LOST PROFITS, ARISING OUT OF THE USE OF THIS SOFTWARE,
//  EVEN IF DANIEL W. MCROBB HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH
//  DAMAGE.
//
//  THE SOFTWARE PROVIDED HEREIN IS ON AN "AS IS" BASIS, AND
//  DANIEL W. MCROBB HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT,
//  UPDATES, ENHANCEMENTS, OR MODIFICATIONS. DANIEL W. MCROBB MAKES NO
//  REPRESENTATIONS AND EXTENDS NO WARRANTIES OF ANY KIND, EITHER
//  IMPLIED OR EXPRESS, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
//  WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE,
//  OR THAT THE USE OF THIS SOFTWARE WILL NOT INFRINGE ANY PATENT,
//  TRADEMARK OR OTHER RIGHTS.
//===========================================================================

//---------------------------------------------------------------------------
//!  \file DwmPiPinDebouncer.cc
//!  \brief Dwm::Pi::PinDebouncer class implementation
//---------------------------------------------------------------------------

#include "DwmSvnTag.hh"
#include "DwmPiPinDebouncer.hh"

static const Dwm::SvnTag svntag("@(#) $DwmPath: dwm/libDwmPi/tags/libDwmPi-0.1.0/src/DwmPiPinDebouncer.cc 8746 $");

namespace Dwm {

  namespace Pi {

    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    SimplePinDebouncer::SimplePinDebouncer(uint8_t initialValue)
    {
      if (initialValue) {
        _filterValue = k_upperThreshold;
        _value = 1;
      }
      else {
        _filterValue = k_lowerThreshold;
        _value = 0;
      }
    }

    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    uint8_t SimplePinDebouncer::Debounce(uint8_t in)
    {
      _filterValue -= (_filterValue >> 2);
      if (in) {
        _filterValue += 0x3F;
      }
      
      if (_filterValue < k_lowerThreshold) {
        _value = 0;
      }
      else if (_filterValue >= k_upperThreshold) {
        _value = 1;
      }
      return(_value);
    }

    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    uint8_t SimplePinDebouncer::Value() const
    {
      return(_value);
    }
    
    
  }  // namespace Pi

}  // namespace Dwm
