//===========================================================================
// @(#) $DwmPath: dwm/libDwmPi/tags/libDwmPi-0.1.0/include/DwmPiGpio.hh 9712 $
// @(#) $Id: DwmPiGpio.hh 9712 2017-07-04 06:08:17Z dwm $
//===========================================================================
//  Copyright (c) Daniel W. McRobb 2016
//  All rights reserved.
//
//  Redistribution and use in source and binary forms, with or without
//  modification, are permitted provided that the following conditions
//  are met:
//
//  1. Redistributions of source code must retain the above copyright
//     notice, this list of conditions and the following disclaimer.
//  2. Redistributions in binary form must reproduce the above copyright
//     notice, this list of conditions and the following disclaimer in the
//     documentation and/or other materials provided with the distribution.
//  3. The names of the authors and copyright holders may not be used to
//     endorse or promote products derived from this software without
//     specific prior written permission.
//
//  IN NO EVENT SHALL DANIEL W. MCROBB BE LIABLE TO ANY PARTY FOR
//  DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES,
//  INCLUDING LOST PROFITS, ARISING OUT OF THE USE OF THIS SOFTWARE,
//  EVEN IF DANIEL W. MCROBB HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH
//  DAMAGE.
//
//  THE SOFTWARE PROVIDED HEREIN IS ON AN "AS IS" BASIS, AND
//  DANIEL W. MCROBB HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT,
//  UPDATES, ENHANCEMENTS, OR MODIFICATIONS. DANIEL W. MCROBB MAKES NO
//  REPRESENTATIONS AND EXTENDS NO WARRANTIES OF ANY KIND, EITHER
//  IMPLIED OR EXPRESS, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
//  WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE,
//  OR THAT THE USE OF THIS SOFTWARE WILL NOT INFRINGE ANY PATENT,
//  TRADEMARK OR OTHER RIGHTS.
//===========================================================================

//---------------------------------------------------------------------------
//!  \file DwmPiGpio.hh
//!  \brief NOT YET DOCUMENTED
//!  \author Daniel W. McRobb <dwm@mcplex.net>
//---------------------------------------------------------------------------

#ifndef _DWMPIGPIO_HH_
#define _DWMPIGPIO_HH_

extern "C" {
  #include <sys/types.h>
  #include <libgpio.h>
}

#include <map>
#include <mutex>
#include <string>

namespace Dwm {

  namespace Pi {

    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    class GpioDevice
    {
    public:
      GpioDevice(unsigned int unit = 0);
      GpioDevice(const std::string & device);
      ~GpioDevice();
      gpio_handle_t & Handle();
      
    private:
      gpio_handle_t  _handle;
    };

    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    class GpioPin
    {
    public:
      typedef enum {
        e_pullNone,
        e_pullUp,
        e_pullDown
      } PullEnum;

      typedef enum {
        e_directionInput,
        e_directionOutput,
        e_directionUnknown
      } DirectionEnum;
      
      //----------------------------------------------------------------------
      //!  
      //----------------------------------------------------------------------
      GpioPin(GpioDevice & device, gpio_pin_t pin, bool input = true);

      //----------------------------------------------------------------------
      //!  
      //----------------------------------------------------------------------
      inline gpio_pin_t Pin() const
      {
        return _pin;
      }
      
      //----------------------------------------------------------------------
      //!  
      //----------------------------------------------------------------------
      std::string Name() const;
      
      //----------------------------------------------------------------------
      //!  
      //----------------------------------------------------------------------
      bool Name(const std::string & name);

      //----------------------------------------------------------------------
      //!  
      //----------------------------------------------------------------------
      DirectionEnum Direction();

      //----------------------------------------------------------------------
      //!  
      //----------------------------------------------------------------------
      bool Direction(DirectionEnum direction);

      //----------------------------------------------------------------------
      //!  
      //----------------------------------------------------------------------
      bool Value() const;

      //----------------------------------------------------------------------
      //!  
      //----------------------------------------------------------------------
      bool Value(bool high);

      //----------------------------------------------------------------------
      //!  
      //----------------------------------------------------------------------
      bool Toggle();

      //----------------------------------------------------------------------
      //!  
      //----------------------------------------------------------------------
      bool Pull(PullEnum pull);

      //----------------------------------------------------------------------
      //!  
      //----------------------------------------------------------------------
      PullEnum Pull() const;

      //----------------------------------------------------------------------
      //!  
      //----------------------------------------------------------------------
      bool InvertInput() const;

      //----------------------------------------------------------------------
      //!  
      //----------------------------------------------------------------------
      bool InvertInput(bool invert);

      //----------------------------------------------------------------------
      //!  
      //----------------------------------------------------------------------
      bool InvertOutput() const;

      //----------------------------------------------------------------------
      //!  
      //----------------------------------------------------------------------
      bool InvertOutput(bool invert);
      
    private:
      GpioDevice                                &_device;
      gpio_pin_t                                 _pin;
      static std::map<gpio_handle_t,std::mutex>  _deviceMutexes;

      friend class GpioDevice;  // for _deviceMutexes
      
      bool GetFlags(uint32_t & flags) const;
      bool SetFlags(uint32_t flags);
      bool ClearFlags(uint32_t flags);
    };
    
  }  // namespace Pi

}  // namespace Dwm

#endif  // _DWMPIGPIO_HH_
