//===========================================================================
// @(#) $Name:$
// @(#) $Id: DwmPfRule.cc 9415 2017-06-03 23:04:48Z dwm $
//===========================================================================
//  Copyright (c) Daniel W. McRobb 2017
//  All rights reserved.
//
//  Redistribution and use in source and binary forms, with or without
//  modification, are permitted provided that the following conditions
//  are met:
//
//  1. Redistributions of source code must retain the above copyright
//     notice, this list of conditions and the following disclaimer.
//  2. Redistributions in binary form must reproduce the above copyright
//     notice, this list of conditions and the following disclaimer in the
//     documentation and/or other materials provided with the distribution.
//  3. The names of the authors and copyright holders may not be used to
//     endorse or promote products derived from this software without
//     specific prior written permission.
//
//  IN NO EVENT SHALL DANIEL W. MCROBB BE LIABLE TO ANY PARTY FOR
//  DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES,
//  INCLUDING LOST PROFITS, ARISING OUT OF THE USE OF THIS SOFTWARE,
//  EVEN IF DANIEL W. MCROBB HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH
//  DAMAGE.
//
//  THE SOFTWARE PROVIDED HEREIN IS ON AN "AS IS" BASIS, AND
//  DANIEL W. MCROBB HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT,
//  UPDATES, ENHANCEMENTS, OR MODIFICATIONS. DANIEL W. MCROBB MAKES NO
//  REPRESENTATIONS AND EXTENDS NO WARRANTIES OF ANY KIND, EITHER
//  IMPLIED OR EXPRESS, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
//  WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE,
//  OR THAT THE USE OF THIS SOFTWARE WILL NOT INFRINGE ANY PATENT,
//  TRADEMARK OR OTHER RIGHTS.
//===========================================================================

//---------------------------------------------------------------------------
//!  \file DwmPfRule.cc
//!  \brief NOT YET DOCUMENTED
//---------------------------------------------------------------------------

extern "C" {
  #include <sys/ioctl.h>
}

#include "DwmSvnTag.hh"
#include "DwmPfDevice.hh"

static const Dwm::SvnTag svntag("@(#) $DwmPath: dwm/libDwmPf/tags/libDwmPf-0.1.6/src/DwmPfRule.cc 9415 $");

using namespace std;

namespace Dwm {

  namespace Pf {

    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    Rule::Rule(const Device & dev, pfioc_rule & pfr, int ruleNum)
        : _dev(dev), _ruleNum(ruleNum)
    {
      pfr.nr = ruleNum;
      if (_dev.Ioctl(DIOCGETRULE, &pfr)) {
        _rule = pfr.rule;
      }
    }

    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    Rule::Rule(const Device & dev, pf_rule & pr, int ruleNum)
        : _dev(dev), _ruleNum(ruleNum), _rule(pr)
    {}

    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    bool Rule::PortMatches(uint8_t op, uint16_t a1, uint16_t a2, uint16_t p)
    {
      switch (op) {
        case PF_OP_IRG:
          return ((p > a1) && (p < a2));
        case PF_OP_XRG:
          return ((p < a1) || (p > a2));
        case PF_OP_RRG:
          return ((p >= a1) && (p <= a2));
        case PF_OP_EQ:
          return (p == a1);
        case PF_OP_NE:
          return (p != a1);
        case PF_OP_LT:
          return (p < a1);
        case PF_OP_LE:
          return (p <= a1);
        case PF_OP_GT:
          return (p > a1);
        case PF_OP_GE:
          return (p >= a1);
      }
      return true;
    }
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    bool Rule::MatchesInbound(const struct in_endpoints & endpoints) const
    {
      bool  rc = false;
      uint16_t  fport = ntohs(endpoints.ie_fport);
      uint16_t  lport = ntohs(endpoints.ie_lport);
#ifndef __APPLE__
      if (! PortMatches(_rule.src.port_op, ntohs(_rule.src.port[0]),
                        ntohs(_rule.src.port[1]), fport)) {
        return rc;
      }
      if (! PortMatches(_rule.dst.port_op, ntohs(_rule.dst.port[0]),
                        ntohs(_rule.dst.port[1]), lport)) {
        return rc;
      }
#else
      if (! PortMatches(_rule.src.xport.range.op,
                        ntohs(_rule.src.xport.range.port[0]),
                        ntohs(_rule.src.xport.range.port[1]), fport)) {
        return rc;
      }
      if (! PortMatches(_rule.dst.xport.range.op,
                        ntohs(_rule.dst.xport.range.port[0]),
                        ntohs(_rule.dst.xport.range.port[1]), lport)) {
        return rc;
      }
#endif      
      bool  matchedSrcAddr = false;
      set<Ipv4Prefix>  && srcPrefixes = SourcePrefixes();
      for (const auto & pfx : srcPrefixes) {
        if (pfx.Contains(endpoints.ie_faddr.s_addr)) {
          matchedSrcAddr = true;
          break;
        }
      }
      if (matchedSrcAddr) {
        set<Ipv4Prefix>  && dstPrefixes = DestinationPrefixes();
        for (const auto & pfx : dstPrefixes) {
          if (pfx.Contains(endpoints.ie_laddr.s_addr)) {
            rc = true;
            break;
          }
        }
      }
      return rc;
    }
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    set<Ipv4Prefix> Rule::DestinationPrefixes() const
    {
      set<Ipv4Prefix>  dstPrefixes;
      
      switch (_rule.dst.addr.type) {
        case PF_ADDR_RANGE:
        case PF_ADDR_ADDRMASK:
          if (PF_AZERO(&_rule.dst.addr.v.a.addr, AF_INET6)
              && PF_AZERO(&_rule.dst.addr.v.a.mask, AF_INET6)) {
            dstPrefixes.insert(Ipv4Prefix("0/0"));
          }
          else {
            Ipv4Prefix  pfx(Ipv4Address(_rule.dst.addr.v.a.addr.v4.s_addr),
                            Ipv4Address(_rule.dst.addr.v.a.mask.v4.s_addr));
            dstPrefixes.insert(pfx);
          }
          break;
        case PF_ADDR_TABLE:
          {
            Table  tbl(_dev, "", _rule.dst.addr.v.tblname);
            vector<Ipv4Prefix>  && tblPfxs = tbl.GetEntries();
            for (auto & tpi : tblPfxs) {
              dstPrefixes.insert(tpi);
            }
          }
          break;
        default:
          break;
      }
      return dstPrefixes;
    }

    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    std::set<Ipv4Prefix> Rule::SourcePrefixes() const
    {
      set<Ipv4Prefix>  srcPrefixes;
      if (_rule.af == AF_INET) {
        switch (_rule.src.addr.type) {
          case PF_ADDR_RANGE:
          case PF_ADDR_ADDRMASK:
            if (PF_AZERO(&_rule.src.addr.v.a.addr, AF_INET6)
                && PF_AZERO(&_rule.src.addr.v.a.mask, AF_INET6)) {
              srcPrefixes.insert(Ipv4Prefix("0/0"));
            }
            else {
              Ipv4Prefix  pfx(Ipv4Address(_rule.src.addr.v.a.addr.v4.s_addr),
                              Ipv4Address(_rule.src.addr.v.a.mask.v4.s_addr));
              srcPrefixes.insert(pfx);
            }
            break;
          case PF_ADDR_TABLE:
            {
              Table  tbl(_dev, "", _rule.src.addr.v.tblname);
              vector<Ipv4Prefix>  && tblPfxs = tbl.GetEntries();
              for (auto & tpi : tblPfxs) {
                srcPrefixes.insert(tpi);
              }
            }
            break;
          default:
            break;
        }
      }
      
      return srcPrefixes;
    }
    

  }  // namespace Pf

}  // namespace Dwm
