//===========================================================================
// @(#) $DwmPath: dwm/libDwmAuth/tags/libDwmAuth-0.3.14/src/DwmAESGCMOutBuffer.cc 10837 $
// @(#) $Id: DwmAESGCMOutBuffer.cc 10837 2020-07-05 09:14:15Z dwm $
//===========================================================================
//  Copyright (c) Daniel W. McRobb 2020
//  All rights reserved.
//
//  Redistribution and use in source and binary forms, with or without
//  modification, are permitted provided that the following conditions
//  are met:
//
//  1. Redistributions of source code must retain the above copyright
//     notice, this list of conditions and the following disclaimer.
//  2. Redistributions in binary form must reproduce the above copyright
//     notice, this list of conditions and the following disclaimer in the
//     documentation and/or other materials provided with the distribution.
//  3. The names of the authors and copyright holders may not be used to
//     endorse or promote products derived from this software without
//     specific prior written permission.
//
//  IN NO EVENT SHALL DANIEL W. MCROBB BE LIABLE TO ANY PARTY FOR
//  DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES,
//  INCLUDING LOST PROFITS, ARISING OUT OF THE USE OF THIS SOFTWARE,
//  EVEN IF DANIEL W. MCROBB HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH
//  DAMAGE.
//
//  THE SOFTWARE PROVIDED HEREIN IS ON AN "AS IS" BASIS, AND
//  DANIEL W. MCROBB HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT,
//  UPDATES, ENHANCEMENTS, OR MODIFICATIONS. DANIEL W. MCROBB MAKES NO
//  REPRESENTATIONS AND EXTENDS NO WARRANTIES OF ANY KIND, EITHER
//  IMPLIED OR EXPRESS, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
//  WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE,
//  OR THAT THE USE OF THIS SOFTWARE WILL NOT INFRINGE ANY PATENT,
//  TRADEMARK OR OTHER RIGHTS.
//===========================================================================

//---------------------------------------------------------------------------
//!  \file DwmAESGCMOutBuffer.cc
//!  \author Daniel W. McRobb
//!  \brief Dwm::AESGCM::OutBuffer class implementation
//---------------------------------------------------------------------------

#include "DwmSvnTag.hh"
#include "DwmPortability.hh"
#include "DwmAESGCMOutBuffer.hh"

static const Dwm::SvnTag svntag("@(#) $DwmPath: dwm/libDwmAuth/tags/libDwmAuth-0.3.14/src/DwmAESGCMOutBuffer.cc 10837 $");

namespace Dwm {

  namespace AESGCM {

    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    OutBuffer::OutBuffer(std::ostream & os, const std::string & key)
        : _os(os), _encryptor()
    {
      using namespace CryptoPP;
      
      if ( sizeof(_key) <= key.size()) {
        memcpy(_key, key.data(), sizeof(_key));
      }
      else {
        throw std::logic_error("Key not long enough!");
      }
      
      _encryptor.GetNextIV(_rng, _iv);
      _encryptor.SetKeyWithIV(_key, sizeof(_key), _iv, sizeof(_iv));
      using AEF = AuthenticatedEncryptionFilter;
      _aef = std::make_unique<AEF>(_encryptor, new StringSink(_msgbuf));
    }

    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    OutBuffer::int_type OutBuffer::overflow(int_type c)
    {
      OutBuffer::int_type  rc = traits_type::eof();
      if (! traits_type::eq_int_type(c, traits_type::eof())) {
        CryptoPP::byte  plainByte = traits_type::to_char_type(c);
        if (_aef->ChannelPut2("", &plainByte, 1, 0, true) == 0) {
          rc = c;
        }
      }
      return rc;
    }

    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    std::streamsize OutBuffer::xsputn(const char *p, std::streamsize n)
    {
      std::streamsize rc = traits_type::eof();
      if (_aef->ChannelPut2("", (const CryptoPP::byte *)p, n, 0, true) == 0) {
        rc = n;
      }
      return rc;
    }
      
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    int OutBuffer::sync()
    {
      using AEF = CryptoPP::AuthenticatedEncryptionFilter;
      using CryptoPP::StringSink;
      
      int  rc = -1;
      _aef->LastPut(0, 0);
      if (_os.write((const char *)_iv, sizeof(_iv))) {
        uint64_t  len = _msgbuf.size();  // note:  MAC is 16 bytes, at end
        len = htobe64(len);
        if (_os.write((const char *)&len, sizeof(len))) {
          if (_os.write(_msgbuf.c_str(), _msgbuf.size())) {
            if (_os.flush()) {
              rc = 0;
            }
          }
        }
      }
      _msgbuf.clear();
      _encryptor.GetNextIV(_rng, _iv);
      _encryptor.Resynchronize(_iv, sizeof(_iv));
      _aef = std::make_unique<AEF>(_encryptor, new StringSink(_msgbuf));
      
      return rc;
    }

    
  }  // namespace AESGCM

}  // namespace Dwm
