//===========================================================================
// @(#) $DwmPath: dwm/libDwmAuth/tags/libDwmAuth-0.3.14/include/DwmAuth.hh 10617 $
// @(#) $Id: DwmAuth.hh 10617 2020-05-02 21:18:04Z dwm $
//===========================================================================
//  Copyright (c) Daniel W. McRobb 2016
//  All rights reserved.
//
//  Redistribution and use in source and binary forms, with or without
//  modification, are permitted provided that the following conditions
//  are met:
//
//  1. Redistributions of source code must retain the above copyright
//     notice, this list of conditions and the following disclaimer.
//  2. Redistributions in binary form must reproduce the above copyright
//     notice, this list of conditions and the following disclaimer in the
//     documentation and/or other materials provided with the distribution.
//  3. The names of the authors and copyright holders may not be used to
//     endorse or promote products derived from this software without
//     specific prior written permission.
//
//  IN NO EVENT SHALL DANIEL W. MCROBB BE LIABLE TO ANY PARTY FOR
//  DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES,
//  INCLUDING LOST PROFITS, ARISING OUT OF THE USE OF THIS SOFTWARE,
//  EVEN IF DANIEL W. MCROBB HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH
//  DAMAGE.
//
//  THE SOFTWARE PROVIDED HEREIN IS ON AN "AS IS" BASIS, AND
//  DANIEL W. MCROBB HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT,
//  UPDATES, ENHANCEMENTS, OR MODIFICATIONS. DANIEL W. MCROBB MAKES NO
//  REPRESENTATIONS AND EXTENDS NO WARRANTIES OF ANY KIND, EITHER
//  IMPLIED OR EXPRESS, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
//  WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE,
//  OR THAT THE USE OF THIS SOFTWARE WILL NOT INFRINGE ANY PATENT,
//  TRADEMARK OR OTHER RIGHTS.
//===========================================================================

//---------------------------------------------------------------------------
//!  \file DwmAuth.hh
//!  \brief Simple authentication definitions
//---------------------------------------------------------------------------

#ifndef _DWMAUTH_HH_
#define _DWMAUTH_HH_

#if 0
#include "DwmAuthPKCrypto.hh"
#endif
#include "DwmAuthSymCrypto.hh"

namespace Dwm {

  namespace Auth {

    //------------------------------------------------------------------------
    //!  Authenticate a client that has connected on the socket @c fd.  We
    //!  will send them our public key from @c myKeys so that they can
    //!  encrypt their response with it.  They will send us their public key
    //!  which we will use to encrypt our challenge.  We will send an IV
    //!  and a random string that is encrypted with the shared secret key
    //!  @c symKey and an IV.  They must decrypt the random string correctly
    //!  and send the decrypted string back to us, encrypted with our public
    //!  key.
    //!  DEPRECATED.  USE Dwm::Auth::PeerAuthenticator!!!!
    //------------------------------------------------------------------------
#if 0
    bool AuthenticateClient(int fd, const PKCrypto::KeyPair & myKeys,
                            const std::string & secret);
#endif
    
    //------------------------------------------------------------------------
    //!  Authenticate to a server to which we've connected on socket @c fd.
    //!  DEPRECATED.  USE Dwm::Auth::PeerAuthenticator!!!!
    //------------------------------------------------------------------------
#if 0
    bool AuthenticateServer(int fd, const PKCrypto::KeyPair & myKeys,
                            const std::string & secret);
#endif
    
    //------------------------------------------------------------------------
    //!  Returns a random string of length @c sz.
    //------------------------------------------------------------------------
    std::string GetRandomString(size_t sz);

    //------------------------------------------------------------------------
    //!  Returns a hexadecimal version of @c s.
    //------------------------------------------------------------------------
    std::string HexEncodedString(const std::string & s);

    //------------------------------------------------------------------------
    //!  Returns a base64-encoded version of @c s.
    //------------------------------------------------------------------------
    std::string Base64Encode(const std::string & s);

  }  // namespace Auth

}  // namespace Dwm

#endif  // _DWMAUTH_HH_
