//===========================================================================
// @(#) $Name:$
// @(#) $Id: TestDnsResolvConf.cc 10030 2018-01-18 03:02:47Z dwm $
//===========================================================================
//  Copyright (c) Daniel W. McRobb 2018
//  All rights reserved.
//
//  Redistribution and use in source and binary forms, with or without
//  modification, are permitted provided that the following conditions
//  are met:
//
//  1. Redistributions of source code must retain the above copyright
//     notice, this list of conditions and the following disclaimer.
//  2. Redistributions in binary form must reproduce the above copyright
//     notice, this list of conditions and the following disclaimer in the
//     documentation and/or other materials provided with the distribution.
//  3. The names of the authors and copyright holders may not be used to
//     endorse or promote products derived from this software without
//     specific prior written permission.
//
//  IN NO EVENT SHALL DANIEL W. MCROBB BE LIABLE TO ANY PARTY FOR
//  DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES,
//  INCLUDING LOST PROFITS, ARISING OUT OF THE USE OF THIS SOFTWARE,
//  EVEN IF DANIEL W. MCROBB HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH
//  DAMAGE.
//
//  THE SOFTWARE PROVIDED HEREIN IS ON AN "AS IS" BASIS, AND
//  DANIEL W. MCROBB HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT,
//  UPDATES, ENHANCEMENTS, OR MODIFICATIONS. DANIEL W. MCROBB MAKES NO
//  REPRESENTATIONS AND EXTENDS NO WARRANTIES OF ANY KIND, EITHER
//  IMPLIED OR EXPRESS, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
//  WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE,
//  OR THAT THE USE OF THIS SOFTWARE WILL NOT INFRINGE ANY PATENT,
//  TRADEMARK OR OTHER RIGHTS.
//===========================================================================

//---------------------------------------------------------------------------
//!  \file TestDnsResolvConf.cc
//!  \brief NOT YET DOCUMENTED
//---------------------------------------------------------------------------

#include "DwmIpv4Address.hh"
#include "DwmSvnTag.hh"
#include "DwmUnitAssert.hh"
#include "DwmDnsResolvConf.hh"

static const Dwm::SvnTag svntag("@(#) $DwmPath: dwm/DwmDns/trunk/classes/tests/TestDnsResolvConf.cc 10030 $");

using namespace std;
using namespace Dwm;

//----------------------------------------------------------------------------
//!  
//----------------------------------------------------------------------------
int main(int argc, char *argv[])
{
  Dns::ResolvConf  resolvConf("./resolv.conf");

  if (UnitAssert(resolvConf.Nameservers().size() == 2)) {
    if (UnitAssert(get<0>(resolvConf.Nameservers()[0].Address()) == AF_INET)) {
      const struct sockaddr_in  *in4Addr =
        (const struct sockaddr_in *)
        get<1>(resolvConf.Nameservers()[0].Address());
      UnitAssert(Ipv4Address(in4Addr->sin_addr.s_addr)
                 == Ipv4Address("8.8.8.8"));
    }
    if (UnitAssert(get<0>(resolvConf.Nameservers()[1].Address()) == AF_INET)) {
      const struct sockaddr_in  *in4Addr =
        (const struct sockaddr_in *)
        get<1>(resolvConf.Nameservers()[1].Address());
      UnitAssert(Ipv4Address(in4Addr->sin_addr.s_addr)
                 == Ipv4Address("192.168.168.1"));
    }
  }
  if (UnitAssert(resolvConf.SearchList().size() == 2)) {
    UnitAssert(resolvConf.SearchList()[0] == "rfdm.com");
    UnitAssert(resolvConf.SearchList()[1] == "mcplex.net");
  }

  if (Assertions::Total().Failed()) {
    Assertions::Print(cerr, true);
    return 1;
  }
  else {
    cout << Assertions::Total() << " passed" << endl;
    return 0;
  }
}

  
