//===========================================================================
// @(#) $DwmPath: dwm/DwmDns/trunk/classes/tests/TestDnsMessageQuestion.cc 9996 $
// @(#) $Id: TestDnsMessageQuestion.cc 9996 2018-01-13 03:24:10Z dwm $
//===========================================================================
//  Copyright (c) Daniel W. McRobb 2018
//  All rights reserved.
//
//  Redistribution and use in source and binary forms, with or without
//  modification, are permitted provided that the following conditions
//  are met:
//
//  1. Redistributions of source code must retain the above copyright
//     notice, this list of conditions and the following disclaimer.
//  2. Redistributions in binary form must reproduce the above copyright
//     notice, this list of conditions and the following disclaimer in the
//     documentation and/or other materials provided with the distribution.
//  3. The names of the authors and copyright holders may not be used to
//     endorse or promote products derived from this software without
//     specific prior written permission.
//
//  IN NO EVENT SHALL DANIEL W. MCROBB BE LIABLE TO ANY PARTY FOR
//  DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES,
//  INCLUDING LOST PROFITS, ARISING OUT OF THE USE OF THIS SOFTWARE,
//  EVEN IF DANIEL W. MCROBB HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH
//  DAMAGE.
//
//  THE SOFTWARE PROVIDED HEREIN IS ON AN "AS IS" BASIS, AND
//  DANIEL W. MCROBB HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT,
//  UPDATES, ENHANCEMENTS, OR MODIFICATIONS. DANIEL W. MCROBB MAKES NO
//  REPRESENTATIONS AND EXTENDS NO WARRANTIES OF ANY KIND, EITHER
//  IMPLIED OR EXPRESS, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
//  WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE,
//  OR THAT THE USE OF THIS SOFTWARE WILL NOT INFRINGE ANY PATENT,
//  TRADEMARK OR OTHER RIGHTS.
//===========================================================================

//---------------------------------------------------------------------------
//!  \file TestDnsMessageQuestion.cc
//!  \brief NOT YET DOCUMENTED
//---------------------------------------------------------------------------

#include "DwmSvnTag.hh"
#include "DwmUnitAssert.hh"
#include "DwmDnsMessageQuestion.hh"

static const Dwm::SvnTag svntag("@(#) $DwmPath: dwm/DwmDns/trunk/classes/tests/TestDnsMessageQuestion.cc 9996 $");

using namespace std;
using namespace Dwm;

//----------------------------------------------------------------------------
//!  
//----------------------------------------------------------------------------
void TestEncodeDecode()
{
  uint8_t  pkt[16384];
  
  vector<Dns::MessageQuestion>  qs = {
    Dns::MessageQuestion("mcplex.net", Dns::MessageQuestion::k_typeA,
                         Dns::MessageQuestion::k_classIN),
    Dns::MessageQuestion("mcplex.net", Dns::MessageQuestion::k_typeNS,
                         Dns::MessageQuestion::k_classIN),
    Dns::MessageQuestion("www.mcplex.net", Dns::MessageQuestion::k_typeCNAME,
                         Dns::MessageQuestion::k_classIN),
    Dns::MessageQuestion("www.rfdm.com", Dns::MessageQuestion::k_typeSOA,
                         Dns::MessageQuestion::k_classIN),
    Dns::MessageQuestion("dwm.rfdm.com", Dns::MessageQuestion::k_typeMB,
                         Dns::MessageQuestion::k_classIN),
    Dns::MessageQuestion("group.mcplex.net", Dns::MessageQuestion::k_typeMG,
                         Dns::MessageQuestion::k_classIN),
    Dns::MessageQuestion("mr.rfdm.com", Dns::MessageQuestion::k_typeMR,
                         Dns::MessageQuestion::k_classIN),
    Dns::MessageQuestion("1.168.168.192.in-addr.arpa",
                         Dns::MessageQuestion::k_typePTR,
                         Dns::MessageQuestion::k_classIN), 
    Dns::MessageQuestion("hinfo.rfdm.com", Dns::MessageQuestion::k_typeHINFO,
                         Dns::MessageQuestion::k_classIN),
    Dns::MessageQuestion("minfo.mcplex.net",
                         Dns::MessageQuestion::k_typeMINFO,
                         Dns::MessageQuestion::k_classIN),
    Dns::MessageQuestion("mail.rfdm.com", Dns::MessageQuestion::k_typeMX,
                         Dns::MessageQuestion::k_classIN),
    Dns::MessageQuestion("txt.mcplex.net", Dns::MessageQuestion::k_typeTXT,
                         Dns::MessageQuestion::k_classIN),
    Dns::MessageQuestion("rp.mcplex.net", Dns::MessageQuestion::k_typeRP,
                         Dns::MessageQuestion::k_classIN),
    Dns::MessageQuestion("key.rfdm.com", Dns::MessageQuestion::k_typeKEY,
                         Dns::MessageQuestion::k_classIN),
    Dns::MessageQuestion("2.1.0.0.0.0.0.0.0.0.0.0.0.0.0.0.f.a.a.6.a.4.f.0.9.1.0.3.0.6.d.f.ip6.arpa", Dns::MessageQuestion::k_typeAAAA,
                         Dns::MessageQuestion::k_classIN),
    Dns::MessageQuestion("loc.rfdm.com", Dns::MessageQuestion::k_typeLOC,
                         Dns::MessageQuestion::k_classIN),
    Dns::MessageQuestion("_smtp._tcp.rfdm.com",
                         Dns::MessageQuestion::k_typeSRV,
                         Dns::MessageQuestion::k_classIN),
    Dns::MessageQuestion("cert.rfdm.com", Dns::MessageQuestion::k_typeCERT,
                         Dns::MessageQuestion::k_classIN),
    Dns::MessageQuestion("ds.rfdm.com", Dns::MessageQuestion::k_typeDS,
                         Dns::MessageQuestion::k_classIN),
    Dns::MessageQuestion("ds.rfdm.com", Dns::MessageQuestion::k_typeDS,
                         Dns::MessageQuestion::k_classIN),
    Dns::MessageQuestion("sshfp.rfdm.com", Dns::MessageQuestion::k_typeSSHFP,
                         Dns::MessageQuestion::k_classIN),
    Dns::MessageQuestion("rrsig.rfdm.com", Dns::MessageQuestion::k_typeRRSIG,
                         Dns::MessageQuestion::k_classIN),
    Dns::MessageQuestion("nsec.mcplex.net", Dns::MessageQuestion::k_typeNSEC,
                         Dns::MessageQuestion::k_classIN),
    Dns::MessageQuestion("dnskey.mcplex.net",
                         Dns::MessageQuestion::k_typeDNSKEY,
                         Dns::MessageQuestion::k_classIN),
    Dns::MessageQuestion("dhcid.mcplex.net", Dns::MessageQuestion::k_typeDHCID,
                         Dns::MessageQuestion::k_classIN),
    Dns::MessageQuestion("nsec3.mcplex.net", Dns::MessageQuestion::k_typeNSEC3,
                         Dns::MessageQuestion::k_classIN),
    Dns::MessageQuestion("nsec3param.mcplex.net",
                         Dns::MessageQuestion::k_typeNSEC3PARAM,
                         Dns::MessageQuestion::k_classIN),
    Dns::MessageQuestion("tlsa.mcplex.net", Dns::MessageQuestion::k_typeTLSA,
                         Dns::MessageQuestion::k_classIN),
    Dns::MessageQuestion("smimea.rfdm.com", Dns::MessageQuestion::k_typeSMIMEA,
                         Dns::MessageQuestion::k_classIN),
    Dns::MessageQuestion("cds.rfdm.com", Dns::MessageQuestion::k_typeCDS,
                         Dns::MessageQuestion::k_classIN),
    Dns::MessageQuestion("cdnskey.mcplex.net",
                         Dns::MessageQuestion::k_typeCDNSKEY,
                         Dns::MessageQuestion::k_classIN),
    Dns::MessageQuestion("openpgpkey.rfdm.com",
                         Dns::MessageQuestion::k_typeOPENPGPKEY,
                         Dns::MessageQuestion::k_classIN),
    Dns::MessageQuestion("uri.mcplex.net", Dns::MessageQuestion::k_typeURI,
                         Dns::MessageQuestion::k_classIN),
    Dns::MessageQuestion("caa.mcplex.net", Dns::MessageQuestion::k_typeCAA,
                         Dns::MessageQuestion::k_classIN)
  };

  uint8_t  *ptr = pkt;
  for (auto & q : qs) {
    Dns::LabelPositions  lps;
    ptr = q.Encode(pkt, ptr, 16384, lps);
  }
  const uint8_t  *rptr = pkt;
  for (auto & q : qs) {
    Dns::MessageQuestion  rq;
    rptr = rq.Decode(pkt, rptr, 16384);
    UnitAssert(rq == q);
  }
  UnitAssert(rptr == ptr);
}

//----------------------------------------------------------------------------
//!  
//----------------------------------------------------------------------------
int main(int argc, char *argv[])
{
  TestEncodeDecode();

  if (Assertions::Total().Failed()) {
    Assertions::Print(cerr, true);
    return 1;
  }
  else {
    cout << Assertions::Total() << " passed" << endl;
    return 0;
  }
  
}
