//===========================================================================
//  Copyright (c) Daniel W. McRobb 2022, 2023
//  All rights reserved.
//
//  Redistribution and use in source and binary forms, with or without
//  modification, are permitted provided that the following conditions
//  are met:
//
//  1. Redistributions of source code must retain the above copyright
//     notice, this list of conditions and the following disclaimer.
//  2. Redistributions in binary form must reproduce the above copyright
//     notice, this list of conditions and the following disclaimer in the
//     documentation and/or other materials provided with the distribution.
//  3. The names of the authors and copyright holders may not be used to
//     endorse or promote products derived from this software without
//     specific prior written permission.
//
//  IN NO EVENT SHALL DANIEL W. MCROBB BE LIABLE TO ANY PARTY FOR
//  DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES,
//  INCLUDING LOST PROFITS, ARISING OUT OF THE USE OF THIS SOFTWARE,
//  EVEN IF DANIEL W. MCROBB HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH
//  DAMAGE.
//
//  THE SOFTWARE PROVIDED HEREIN IS ON AN "AS IS" BASIS, AND
//  DANIEL W. MCROBB HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT,
//  UPDATES, ENHANCEMENTS, OR MODIFICATIONS. DANIEL W. MCROBB MAKES NO
//  REPRESENTATIONS AND EXTENDS NO WARRANTIES OF ANY KIND, EITHER
//  IMPLIED OR EXPRESS, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
//  WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE,
//  OR THAT THE USE OF THIS SOFTWARE WILL NOT INFRINGE ANY PATENT,
//  TRADEMARK OR OTHER RIGHTS.
//===========================================================================

//---------------------------------------------------------------------------
//!  \file DwmMcroverWebAppTarget.cc
//!  \author Daniel W. McRobb
//!  \brief Dwm::Mcrover::WebAppTarget class implementation
//---------------------------------------------------------------------------

#include "DwmMcroverWebAppTarget.hh"

namespace Dwm {

  namespace Mcrover {

    using namespace std;
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    WebAppTarget::WebAppTarget()
        : _uri(), _validateCertificate(true), _xpath(), _params(), _appName()
    {}
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    const string & WebAppTarget::URI() const
    {
      return _uri;
    }

    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    const string & WebAppTarget::URI(const string & uri)
    {
      _uri = uri;
      return _uri;
    }

    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    const string & WebAppTarget::AppName() const
    {
      return _appName;
    }

    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    const string & WebAppTarget::AppName(const string & appName)
    {
      return _appName = appName;
    }

    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    const vector<string> & WebAppTarget::Params() const
    {
      return _params;
    }

    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    const vector<string> &
    WebAppTarget::Params(const vector<string> & params)
    {
      return _params = params;
    }

    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    const string & WebAppTarget::Xpath() const
    {
      return _xpath;
    }
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    const string & WebAppTarget::Xpath(const string & xpath)
    {
      return _xpath = xpath;
    }

    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    bool WebAppTarget::ValidateCertificate() const
    {
      return _validateCertificate;
    }
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    bool WebAppTarget::ValidateCertificate(bool validateCertificate)
    {
      return _validateCertificate = validateCertificate;
    }

    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    nlohmann::json WebAppTarget::ToJson() const
    {
      nlohmann::json  j;
      j["uri"] = _uri;
      j["validateCertificate"] = _validateCertificate;
      if (! _xpath.empty()) {
        j["xpath"] = _xpath;
      }
      for (size_t p = 0; p < _params.size(); ++p) {
        j["params"][p] = _params[p];
      }
      j["appName"] = _appName;
      return j;
    }

    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    bool WebAppTarget::FromJson(const nlohmann::json & j)
    {
      bool  rc = false;
      
      _uri.clear();
      _validateCertificate = true;
      _xpath.clear();
      _params.clear();
      _appName.clear();

      if (j.is_object()) {
        auto it = j.find("uri");
        if ((it != j.end()) && it->is_string()) {
          _uri = it->get<string>();
          it = j.find("appName");
          if ((it != j.end()) && it->is_string()) {
            _appName = it->get<string>();
            rc = true;
          }
          it = j.find("validateCertificate");
          if ((it != j.end()) && it->is_boolean()) {
            _validateCertificate = it->get<bool>();
          }
          it = j.find("xpath");
          if ((it != j.end()) && it->is_string()) {
            _xpath = it->get<string>();
          }
          it = j.find("params");
          if ((it != j.end()) && it->is_array()) {
            for (size_t p = 0; p < it->size(); ++p) {
              if ((*it)[p].is_string()) {
                _params.push_back((*it)[p].get<string>());
              }
            }
          }
        }
      }
      return rc;
    }
    
  }  // namespace Mcrover

}  // namespace Dwm
