%{
  //  I believe this is correct BNF for the "shortForecast" in
  //  the JSON from the NWS.
  //  All I care about here is what to draw in the weather image
  //  summary widget.
%}

%code requires
{
  #include <string>
  #include <vector>

  #include "DwmMcroverWeatherImageData.hh"

  using std::vector, std::string, Dwm::Mcrover::Weather::ImageData;
}

%{
  #include <cstdio>
  #include <mutex>
  #include <vector>
  #include "DwmMcroverWeatherImageData.hh"

  extern "C" {
    #include <netdb.h>

    extern void mcrovershortforecasterror(const char *arg, ...);
  }

  using std::vector, std::string, Dwm::Mcrover::Weather::ImageData;

  vector<vector<ImageData>>  *g_data = nullptr;
  string                      g_forecastString;
%}

%define api.prefix {mcrovershortforecast}

%union {
  ImageData                  *weatherImageDataVal;
  vector<ImageData>          *weatherImageDataVecVal;
  vector<vector<ImageData>>  *forecastVecVal;
}

%code provides
{
  // Tell Flex the expected prototype of yylex.
  #define YY_DECL                             \
    int mcrovershortforecastlex ()

  // Declare the scanner.
  YY_DECL;
}

%token AND AREAS CHANCE CLEAR CLOUDY FOG ISOLATED LIGHT LIKELY MOSTLY OF
%token PARTLY RAIN SHOWERS SLIGHT SNOW SUNNY THEN THUNDERSTORMS

%type<weatherImageDataVal>     Precipitation
%type<weatherImageDataVecVal>  Forecast NoPrecipitationForecast
%type<weatherImageDataVecVal>  PrecipitationForecast Precipitations
%type<forecastVecVal>          Forecasts

%%

Forecasts: Forecast
{
  g_data->push_back(*$1);
  delete $1;
}
| Forecasts THEN Forecast
{
  g_data->push_back(*$3);
  delete $3;
}
;

Forecast : NoPrecipitationForecast
{
  $$ = $1;
}
| PrecipitationForecast
{
  $$ = $1;
}
;

NoPrecipitationForecast:
SUNNY
{
  $$ = new std::vector<Dwm::Mcrover::Weather::ImageData>(1);
  $$->front().cloudLevel = 0;
}
| MOSTLY SUNNY
{
  $$ = new std::vector<Dwm::Mcrover::Weather::ImageData>(1);
  $$->front().cloudLevel = 1;
}
| PARTLY SUNNY
{
  $$ = new std::vector<Dwm::Mcrover::Weather::ImageData>(1);
  $$->front().cloudLevel = 2;
}
| MOSTLY CLEAR
{
  $$ = new std::vector<Dwm::Mcrover::Weather::ImageData>(1);
  $$->front().cloudLevel = 1;
}
| CLEAR
{
  $$ = new std::vector<Dwm::Mcrover::Weather::ImageData>(1);
  $$->front().cloudLevel = 0;
}
| PARTLY CLOUDY
{
  $$ = new std::vector<Dwm::Mcrover::Weather::ImageData>(1);
  $$->front().cloudLevel = 3;
}
| MOSTLY CLOUDY
{
  $$ = new std::vector<Dwm::Mcrover::Weather::ImageData>(1);
  $$->front().cloudLevel = 4;
}
| CLOUDY
{
  $$ = new std::vector<Dwm::Mcrover::Weather::ImageData>(1);
  $$->front().cloudLevel = 5;
}
| AREAS OF FOG
{
  $$ = new std::vector<Dwm::Mcrover::Weather::ImageData>(1);
  $$->front().cloudLevel = 3;
}        
;

PrecipitationForecast : ISOLATED Precipitations
{
  $$ = $2;
  for (auto & p : *$$) {
    p.precipChance = 1;
  }
}
| SLIGHT CHANCE Precipitations
{
  $$ = $3;
  for (auto & p : *$$) {
    p.precipChance = 2;
  }
}
| CHANCE Precipitations
{
  $$ = $2;
  for (auto & p : *$$) {
    p.precipChance = 3;
  }
}
| Precipitations LIKELY
{
  $$ = $1;
  for (auto & p : *$$) {
    p.precipChance = 4;
  }
}
| Precipitations
{
  $$ = $1;
  for (auto & p : *$$) {
    p.precipChance = 4;
  }
}
;

Precipitations: Precipitation
{
  $$ = new std::vector<ImageData>();
  $$->push_back(*$1);
  delete $1;
}
| Precipitations AND Precipitation
{
  $$->push_back(*$3);
  delete $3;
};

Precipitation:
LIGHT RAIN
{
  $$ = new Dwm::Mcrover::Weather::ImageData();
  $$->cloudLevel = 2;
  $$->rainLevel = 1;
}
| RAIN
{
  $$ = new Dwm::Mcrover::Weather::ImageData();
  $$->cloudLevel = 3;
  $$->rainLevel = 2;
}
| LIGHT SNOW
{
  $$ = new Dwm::Mcrover::Weather::ImageData();
  $$->cloudLevel = 2;
  $$->snowLevel = 1;
}
| SNOW
{
  $$ = new Dwm::Mcrover::Weather::ImageData();
  $$->cloudLevel = 3;
  $$->snowLevel = 2;
}
| SHOWERS
{
  $$ = new Dwm::Mcrover::Weather::ImageData();
  $$->cloudLevel = 4;
  $$->rainLevel = 3;
}
| THUNDERSTORMS
{
  $$ = new Dwm::Mcrover::Weather::ImageData();
  $$->cloudLevel = 5;
  $$->rainLevel = 4;
}
| RAIN SHOWERS
{
  $$ = new Dwm::Mcrover::Weather::ImageData();
  $$->cloudLevel = 4;
  $$->rainLevel = 3;
}
| SNOW SHOWERS
{
  $$ = new Dwm::Mcrover::Weather::ImageData();
  $$->cloudLevel = 4;
  $$->snowLevel = 3;
}
;

%%

extern void SetForecastScanString(const char *s);
extern void EndShortForecastScan();

namespace Dwm {

  namespace Mcrover {
    
    namespace Weather {
      
      using namespace std;
      
      bool ParseShortForecast(const string & s,
                              vector<vector<ImageData>> & data)
      {
        bool          rc = false;
        static mutex  mtx;
        lock_guard<mutex>  lck(mtx);
        g_forecastString = s;
        g_data = &data;
        SetForecastScanString(s.c_str());
        rc = (0 == mcrovershortforecastparse());
        EndShortForecastScan();
        return rc;
      }
      
    }  // namespace Weather
    
  }  // namespace Mcrover
  
}  // namespace Dwm
