//===========================================================================
// @(#) $DwmPath: dwm/mcplex/mcrover/tags/mcrover-0.1.1/classes/src/DwmMcroverNameServerData.cc 11049 $
// @(#) $Id: DwmMcroverNameServerData.cc 11049 2020-08-31 03:40:46Z dwm $
//===========================================================================
//  Copyright (c) Daniel W. McRobb 2020
//  All rights reserved.
//
//  Redistribution and use in source and binary forms, with or without
//  modification, are permitted provided that the following conditions
//  are met:
//
//  1. Redistributions of source code must retain the above copyright
//     notice, this list of conditions and the following disclaimer.
//  2. Redistributions in binary form must reproduce the above copyright
//     notice, this list of conditions and the following disclaimer in the
//     documentation and/or other materials provided with the distribution.
//  3. The names of the authors and copyright holders may not be used to
//     endorse or promote products derived from this software without
//     specific prior written permission.
//
//  IN NO EVENT SHALL DANIEL W. MCROBB BE LIABLE TO ANY PARTY FOR
//  DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES,
//  INCLUDING LOST PROFITS, ARISING OUT OF THE USE OF THIS SOFTWARE,
//  EVEN IF DANIEL W. MCROBB HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH
//  DAMAGE.
//
//  THE SOFTWARE PROVIDED HEREIN IS ON AN "AS IS" BASIS, AND
//  DANIEL W. MCROBB HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT,
//  UPDATES, ENHANCEMENTS, OR MODIFICATIONS. DANIEL W. MCROBB MAKES NO
//  REPRESENTATIONS AND EXTENDS NO WARRANTIES OF ANY KIND, EITHER
//  IMPLIED OR EXPRESS, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
//  WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE,
//  OR THAT THE USE OF THIS SOFTWARE WILL NOT INFRINGE ANY PATENT,
//  TRADEMARK OR OTHER RIGHTS.
//===========================================================================

//---------------------------------------------------------------------------
//!  \file DwmMcroverNameServerData.cc
//!  \author Daniel W. McRobb
//!  \brief Dwm::Mcrover::NameServerData class implementation
//---------------------------------------------------------------------------

#include <algorithm>
#include <thread>

#include "DwmMcroverNameServerData.hh"

namespace Dwm {

  namespace Mcrover {

    using namespace std;
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    NameServerData::NameServerData(const Ipv4Address & addr)
        : _nameServer(addr), _questions()
    {
    }

    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    Dns::NameServer & NameServerData::NS()
    {
      return _nameServer;
    }

    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    bool NameServerData::SendQuestions()
    {
      bool  rc = true;
      for (const auto & q : _questions) {
        Dns::Message  outMsg;
        outMsg.Header().RecursionDesired(true);
        outMsg.EnableEDNS(512, false);
        outMsg.Questions().push_back(q);
        if (! _nameServer.SendMessage(outMsg)) {
          rc = false;
          break;
        }
        this_thread::sleep_for(chrono::milliseconds(5));
      }
      return rc;
    }
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    uint32_t  NameServerData::ReceiveAnswers()
    {
      uint32_t  rc = 0;
      struct timeval  tv = { 0, 50000 };
      if (_nameServer.AnswerWaiting(tv)) {
        Dns::Message  msg;
        if (_nameServer.ReceiveMessage(msg)) {
          ++rc;
          for (const auto & recvdQuestion : msg.Questions()) {
            auto qit = find(_questions.begin(), _questions.end(),
                            recvdQuestion);
            if ((qit != _questions.end()) && (! msg.Answers().empty())) {
              _questions.erase(qit);
            }
          }
        }
      }
      return rc;
    }
    

  }  // namespace Mcrover

}  // namespace Dwm
