//===========================================================================
// @(#) $DwmPath: dwm/mcplex/mcrover/tags/mcrover-0.1.1/classes/src/DwmMcroverLocalNetInterface.cc 11962 $
// @(#) $Id: DwmMcroverLocalNetInterface.cc 11962 2022-04-23 18:15:56Z dwm $
//===========================================================================
//  Copyright (c) Daniel W. McRobb 2020
//  All rights reserved.
//
//  Redistribution and use in source and binary forms, with or without
//  modification, are permitted provided that the following conditions
//  are met:
//
//  1. Redistributions of source code must retain the above copyright
//     notice, this list of conditions and the following disclaimer.
//  2. Redistributions in binary form must reproduce the above copyright
//     notice, this list of conditions and the following disclaimer in the
//     documentation and/or other materials provided with the distribution.
//  3. The names of the authors and copyright holders may not be used to
//     endorse or promote products derived from this software without
//     specific prior written permission.
//
//  IN NO EVENT SHALL DANIEL W. MCROBB BE LIABLE TO ANY PARTY FOR
//  DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES,
//  INCLUDING LOST PROFITS, ARISING OUT OF THE USE OF THIS SOFTWARE,
//  EVEN IF DANIEL W. MCROBB HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH
//  DAMAGE.
//
//  THE SOFTWARE PROVIDED HEREIN IS ON AN "AS IS" BASIS, AND
//  DANIEL W. MCROBB HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT,
//  UPDATES, ENHANCEMENTS, OR MODIFICATIONS. DANIEL W. MCROBB MAKES NO
//  REPRESENTATIONS AND EXTENDS NO WARRANTIES OF ANY KIND, EITHER
//  IMPLIED OR EXPRESS, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
//  WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE,
//  OR THAT THE USE OF THIS SOFTWARE WILL NOT INFRINGE ANY PATENT,
//  TRADEMARK OR OTHER RIGHTS.
//===========================================================================

//---------------------------------------------------------------------------
//!  \file DwmMcroverLocalNetInterface.cc
//!  \author Daniel W. McRobb
//!  \brief Dwm::Mcrover::LocalNetInterface class implementation
//---------------------------------------------------------------------------

#include "DwmIpv4Prefix.hh"
#include "DwmSvnTag.hh"
#include "DwmMcroverLocalNetInterface.hh"

static const Dwm::SvnTag svntag("@(#) $DwmPath: dwm/mcplex/mcrover/tags/mcrover-0.1.1/classes/src/DwmMcroverLocalNetInterface.cc 11962 $");

namespace Dwm {

  namespace Mcrover {

    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    LocalNetInterface::LocalNetInterface()
        : _name(), _ipv4Addr(INADDR_NONE), _ipv4AddrBits(32), _ipv6Addr(),
          _isUp(false), _isLoopback(false), _ipv4Aliases()
    {
    }
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    LocalNetInterface::LocalNetInterface(const intf_entry *ifEntry)
        : _name(), _ipv4Addr(INADDR_NONE), _ipv4AddrBits(32), _ipv6Addr(),
          _isUp(false), _isLoopback(false), _ipv4Aliases()
    {
      if (ifEntry) {
        _name = ifEntry->intf_name;
        if (ifEntry->intf_addr.addr_type == ADDR_TYPE_IP) {
          _ipv4Addr = Ipv4Address(ifEntry->intf_addr.addr_ip);
          _ipv4AddrBits = ifEntry->intf_addr.addr_bits;
        }
        else if (ifEntry->intf_addr.addr_type == ADDR_TYPE_IP6) {
          const in6_addr  *in6Addr =
            (const in6_addr *)(&(ifEntry->intf_addr.addr_ip6));
          _ipv6Addr = Ipv6Address(*in6Addr);
        }
        if (ifEntry->intf_flags & INTF_FLAG_UP) {
          _isUp = true;
        }
        if (ifEntry->intf_flags & INTF_FLAG_LOOPBACK) {
          _isLoopback = true;
        }
        for (size_t i = 0; i < ifEntry->intf_alias_num; ++i) {
          const  auto  *alias = &(ifEntry->intf_alias_addrs[i]);
          if (alias->addr_type == ADDR_TYPE_IP) {
            _ipv4Aliases.push_back(Ipv4Address(alias->addr_ip));
          }
        }
      }
    }
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    const std::string & LocalNetInterface::Name() const
    {
      return _name;
    }
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    const Ipv4Address & LocalNetInterface::Ipv4Addr() const
    {
      return _ipv4Addr;
    }

    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    Ipv4Address LocalNetInterface::Ipv4Netmask() const
    {
      return Ipv4Prefix(0xFFFFFFFF, _ipv4AddrBits).Network();
    }

    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    Ipv4Prefix LocalNetInterface::Ipv4Network() const
    {
      return Ipv4Prefix(_ipv4Addr, _ipv4AddrBits);
    }

    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    const Ipv6Address & LocalNetInterface::Ipv6Addr() const
    {
      return _ipv6Addr;
    }

    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    bool LocalNetInterface::IsUp() const
    {
      return _isUp;
    }
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    bool LocalNetInterface::IsLoopback() const
    {
      return _isLoopback;
    }

    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    const std::vector<Ipv4Address> & LocalNetInterface::Ipv4Aliases() const
    {
      return _ipv4Aliases;
    }
    
  }  // namespace Mcrover

}  // namespace Dwm
