//===========================================================================
// @(#) $DwmPath$
//===========================================================================
//  Copyright (c) Daniel W. McRobb 2022
//  All rights reserved.
//
//  Redistribution and use in source and binary forms, with or without
//  modification, are permitted provided that the following conditions
//  are met:
//
//  1. Redistributions of source code must retain the above copyright
//     notice, this list of conditions and the following disclaimer.
//  2. Redistributions in binary form must reproduce the above copyright
//     notice, this list of conditions and the following disclaimer in the
//     documentation and/or other materials provided with the distribution.
//  3. The names of the authors and copyright holders may not be used to
//     endorse or promote products derived from this software without
//     specific prior written permission.
//
//  IN NO EVENT SHALL DANIEL W. MCROBB BE LIABLE TO ANY PARTY FOR
//  DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES,
//  INCLUDING LOST PROFITS, ARISING OUT OF THE USE OF THIS SOFTWARE,
//  EVEN IF DANIEL W. MCROBB HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH
//  DAMAGE.
//
//  THE SOFTWARE PROVIDED HEREIN IS ON AN "AS IS" BASIS, AND
//  DANIEL W. MCROBB HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT,
//  UPDATES, ENHANCEMENTS, OR MODIFICATIONS. DANIEL W. MCROBB MAKES NO
//  REPRESENTATIONS AND EXTENDS NO WARRANTIES OF ANY KIND, EITHER
//  IMPLIED OR EXPRESS, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
//  WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE,
//  OR THAT THE USE OF THIS SOFTWARE WILL NOT INFRINGE ANY PATENT,
//  TRADEMARK OR OTHER RIGHTS.
//===========================================================================

//---------------------------------------------------------------------------
//!  \file DwmMcroverCredencePeerUtils.cc
//!  \author Daniel W. McRobb
//!  \brief Dwm::Mcrover::CredencePeerUtils class implementation
//---------------------------------------------------------------------------

#include "DwmCredencePeer.hh"
#include "DwmMcroverCredencePeerUtils.hh"

namespace Dwm {

  namespace Mcrover {

    using namespace std;
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    bool CredencePeerUtils::GetAlerts(const AlertOrigin & origin,
                                      const Config & config,
                                      AlertBowl & alerts, bool clearAtEntry)
    {
      using CPA = CredencePeerAlert;
      
      bool  rc = false;
      if (clearAtEntry) {
        alerts.Clear();
      }

      size_t  numOrigAlerts = alerts.Size();
      
      for (const auto & thcfg : config.Servers()) {
        for (const auto & cpcfg : thcfg.CredencePeerTargets()) {
          Credence::Peer  peer;
          if (peer.Connect((string)cpcfg.Address(), cpcfg.Port())) {
            Credence::KeyStash  keyStash(config.Service().KeyDirectory());
            if (keyStash.IsValid()) {
              Credence::KnownKeys  knownKeys(config.Service().KeyDirectory());
              if (! knownKeys.Keys().empty()) {
                if (! peer.Authenticate(keyStash, knownKeys)) {
                  CPA  cpalert(cpcfg, CPA::e_stepAuthenticate);
                  alerts.Add(origin, cpalert, time((time_t *)0));
                }
              }
              else {
                CPA  cpalert(cpcfg, CPA::e_stepGetKnownKeys);
                alerts.Add(origin, cpalert, time((time_t *)0));
              }
            }
            else {
              CPA  cpalert(cpcfg, CPA::e_stepGetMyKeys);
              alerts.Add(origin, cpalert, time((time_t *)0));
            }
            peer.Disconnect();
          }
          else {
            CPA  cpalert(cpcfg, CPA::e_stepConnect);
            alerts.Add(origin, cpalert, time((time_t *)0));
          }
        }
      }
      
      return (alerts.Size() > numOrigAlerts);
    }
    
  }  // namespace Mcrover

}  // namespace Dwm
