//===========================================================================
// @(#) $DwmPath: dwm/mcplex/mcrover/tags/mcrover-0.1.1/classes/src/DwmMcroverBanditAlert.cc 11886 $
// @(#) $Id: DwmMcroverBanditAlert.cc 11886 2021-04-07 05:16:39Z dwm $
//===========================================================================
//  Copyright (c) Daniel W. McRobb 2020
//  All rights reserved.
//
//  Redistribution and use in source and binary forms, with or without
//  modification, are permitted provided that the following conditions
//  are met:
//
//  1. Redistributions of source code must retain the above copyright
//     notice, this list of conditions and the following disclaimer.
//  2. Redistributions in binary form must reproduce the above copyright
//     notice, this list of conditions and the following disclaimer in the
//     documentation and/or other materials provided with the distribution.
//  3. The names of the authors and copyright holders may not be used to
//     endorse or promote products derived from this software without
//     specific prior written permission.
//
//  IN NO EVENT SHALL DANIEL W. MCROBB BE LIABLE TO ANY PARTY FOR
//  DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES,
//  INCLUDING LOST PROFITS, ARISING OUT OF THE USE OF THIS SOFTWARE,
//  EVEN IF DANIEL W. MCROBB HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH
//  DAMAGE.
//
//  THE SOFTWARE PROVIDED HEREIN IS ON AN "AS IS" BASIS, AND
//  DANIEL W. MCROBB HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT,
//  UPDATES, ENHANCEMENTS, OR MODIFICATIONS. DANIEL W. MCROBB MAKES NO
//  REPRESENTATIONS AND EXTENDS NO WARRANTIES OF ANY KIND, EITHER
//  IMPLIED OR EXPRESS, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
//  WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE,
//  OR THAT THE USE OF THIS SOFTWARE WILL NOT INFRINGE ANY PATENT,
//  TRADEMARK OR OTHER RIGHTS.
//===========================================================================

//---------------------------------------------------------------------------
//!  \file DwmMcroverBanditAlert.cc
//!  \author Daniel W. McRobb
//!  \brief Dwm::Mcrover::BanditAlert class implementation
//---------------------------------------------------------------------------

#include "DwmDescriptorIO.hh"
#include "DwmFileIO.hh"
#include "DwmIOUtils.hh"
#include "DwmStreamIO.hh"
#include "DwmIpv4Address.hh"
#include "DwmSvnTag.hh"
#include "DwmMcroverBanditAlert.hh"
#include "DwmMcroverUtils.hh"

static const Dwm::SvnTag svntag("@(#) $DwmPath: dwm/mcplex/mcrover/tags/mcrover-0.1.1/classes/src/DwmMcroverBanditAlert.cc 11886 $");

namespace Dwm {

  namespace Mcrover {

    using namespace std;
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    BanditAlert::BanditAlert()
        : _macAndIp(MacAddress(), INADDR_NONE)
    {
    }
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    BanditAlert::BanditAlert(const MacAddress & banditMac,
                             const Ipv4Address & banditIp)
        : _macAndIp(banditMac, banditIp)
    {}
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    string BanditAlert::DisplayString() const
    {
      return ((string)_macAndIp.first + ","
              + (string)_macAndIp.second + " BANDIT");
    }

    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    nlohmann::json BanditAlert::ToJson() const
    {
      nlohmann::json  j;

      j["mac"] = (string)_macAndIp.first;
      j["ip"] = (string)_macAndIp.second;
      return j;
    }
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    bool BanditAlert::FromJson(const nlohmann::json & j)
    {
      bool  rc = false;
      _macAndIp.first = MacAddress();
      _macAndIp.second = INADDR_NONE;
      if (j.is_object()) {
        auto  mac = j.find("mac");
        if ((mac != j.end()) && mac->is_string()) {
          _macAndIp.first = MacAddress(mac->get<string>());
          auto  ip = j.find("ip");
          if ((ip != j.end()) && ip->is_string()) {
            _macAndIp.second = Ipv4Address(ip->get<string>());
            rc = true;
          }
        }
      }
      return rc;
    }
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    istream & BanditAlert::Read(istream & is)
    {
      _macAndIp.first = MacAddress();
      _macAndIp.second = INADDR_NONE;
      return StreamIO::Read(is, _macAndIp);
    }
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    ssize_t BanditAlert::Read(int fd)
    {
      _macAndIp.first = MacAddress();
      _macAndIp.second = INADDR_NONE;
      return DescriptorIO::Read(fd, _macAndIp);
    }
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    size_t BanditAlert::Read(FILE * f)
    {
      _macAndIp.first = MacAddress();
      _macAndIp.second = INADDR_NONE;
      return FileIO::Read(f, _macAndIp);
    }
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    ostream & BanditAlert::Write(ostream & os) const
    {
      return StreamIO::Write(os, _macAndIp);
    }
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    ssize_t BanditAlert::Write(int fd) const
    {
      return DescriptorIO::Write(fd, _macAndIp);
    }
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    size_t BanditAlert::Write(FILE *f) const
    {
      return FileIO::Write(f, _macAndIp);
    }
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    uint64_t BanditAlert::StreamedLength() const
    {
      return (IOUtils::StreamedLength(_macAndIp));
    }
    
  }  // namespace Mcrover

}  // namespace Dwm
