//===========================================================================
// @(#) $DwmPath: dwm/mcplex/mcrover/tags/mcrover-0.1.1/classes/include/DwmMcroverUtils.hh 11980 $
// @(#) $Id: DwmMcroverUtils.hh 11980 2022-04-25 02:30:15Z dwm $
//===========================================================================
//  Copyright (c) Daniel W. McRobb 2020
//  All rights reserved.
//
//  Redistribution and use in source and binary forms, with or without
//  modification, are permitted provided that the following conditions
//  are met:
//
//  1. Redistributions of source code must retain the above copyright
//     notice, this list of conditions and the following disclaimer.
//  2. Redistributions in binary form must reproduce the above copyright
//     notice, this list of conditions and the following disclaimer in the
//     documentation and/or other materials provided with the distribution.
//  3. The names of the authors and copyright holders may not be used to
//     endorse or promote products derived from this software without
//     specific prior written permission.
//
//  IN NO EVENT SHALL DANIEL W. MCROBB BE LIABLE TO ANY PARTY FOR
//  DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES,
//  INCLUDING LOST PROFITS, ARISING OUT OF THE USE OF THIS SOFTWARE,
//  EVEN IF DANIEL W. MCROBB HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH
//  DAMAGE.
//
//  THE SOFTWARE PROVIDED HEREIN IS ON AN "AS IS" BASIS, AND
//  DANIEL W. MCROBB HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT,
//  UPDATES, ENHANCEMENTS, OR MODIFICATIONS. DANIEL W. MCROBB MAKES NO
//  REPRESENTATIONS AND EXTENDS NO WARRANTIES OF ANY KIND, EITHER
//  IMPLIED OR EXPRESS, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
//  WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE,
//  OR THAT THE USE OF THIS SOFTWARE WILL NOT INFRINGE ANY PATENT,
//  TRADEMARK OR OTHER RIGHTS.
//===========================================================================

//---------------------------------------------------------------------------
//!  \file DwmMcroverUtils.hh
//!  \author Daniel W. McRobb
//!  \brief Dwm::Mcrover::Utils class declaration
//---------------------------------------------------------------------------

#ifndef _DWMMCROVERUTILS_HH_
#define _DWMMCROVERUTILS_HH_

#include <cstdint>
#include <map>
#include <string>

#include "DwmIpAddress.hh"
#include "DwmMacAddress.hh"
#include "DwmMcroverLocalNetInterface.hh"

namespace Dwm {

  namespace Mcrover {

    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    class Utils
    {
    public:
      //----------------------------------------------------------------------
      //!  
      //----------------------------------------------------------------------
      static uint32_t GetHostIpv4Addr(const std::string & nameOrAddr);

      //----------------------------------------------------------------------
      //!  
      //----------------------------------------------------------------------
      static Ipv6Address GetHostIpv6Addr(const std::string & nameOrAddr);

      //----------------------------------------------------------------------
      //!  
      //----------------------------------------------------------------------
      static std::string GetHostName(uint32_t addr);

      //----------------------------------------------------------------------
      //!  
      //----------------------------------------------------------------------
      static std::string GetHostName(const Ipv6Address & addr);

      //----------------------------------------------------------------------
      //!  
      //----------------------------------------------------------------------
      static std::string GetHostName(const IpAddress & addr);

      //----------------------------------------------------------------------
      //!  
      //----------------------------------------------------------------------
      static std::string ThisHostName();

      //----------------------------------------------------------------------
      //!  
      //----------------------------------------------------------------------
      static IpAddress ThisHostAddr();
      
      //----------------------------------------------------------------------
      //!  
      //----------------------------------------------------------------------
      static uint32_t ThisHostIpv4Addr();

      //----------------------------------------------------------------------
      //!  
      //----------------------------------------------------------------------
      static Ipv6Address ThisHostIpv6Addr();

      //----------------------------------------------------------------------
      //!  
      //----------------------------------------------------------------------
      static uint32_t ThisHostDefaultIpv4Route();

      //----------------------------------------------------------------------
      //!  
      //----------------------------------------------------------------------
      static bool ThisHostIpv4Routes(std::map<Ipv4Prefix,Ipv4Address> &);

      //----------------------------------------------------------------------
      //!  
      //----------------------------------------------------------------------
      static bool ThisHostsRouteTo(const Ipv4Prefix & prefix,
                                   Ipv4Address & gw);
      
      //----------------------------------------------------------------------
      //!  
      //----------------------------------------------------------------------
      static bool IsPrivateIpv4Addr(uint32_t addr);

      //----------------------------------------------------------------------
      //!  
      //----------------------------------------------------------------------
      static bool ThisHostInterfaces(std::vector<LocalNetInterface> &);

      //----------------------------------------------------------------------
      //!  
      //----------------------------------------------------------------------
      static bool IsLocalAddress(const Ipv4Address & addr);

      //----------------------------------------------------------------------
      //!  
      //----------------------------------------------------------------------
      static bool IsLinkLocalAddress(const Ipv6Address & addr);
      
      //----------------------------------------------------------------------
      //!  
      //----------------------------------------------------------------------
      static bool ThisHostArpEntries(std::map<Ipv4Address,MacAddress> &);
      
      //----------------------------------------------------------------------
      //!  
      //----------------------------------------------------------------------
      static bool HaveArpEntry(const Ipv4Address & addr);
    };
    
  }  // namespace Mcrover

}  // namespace Dwm

#endif  // _DWMMCROVERUTILS_HH_
