//===========================================================================
// @(#) $DwmPath: dwm/mcplex/mcrover/tags/mcrover-0.1.1/apps/qmcrover/main.cc 12048 $
// @(#) $Id: main.cc 12048 2022-10-24 13:41:59Z dwm $
//===========================================================================
//  Copyright (c) Daniel W. McRobb 2020
//  All rights reserved.
//
//  Redistribution and use in source and binary forms, with or without
//  modification, are permitted provided that the following conditions
//  are met:
//
//  1. Redistributions of source code must retain the above copyright
//     notice, this list of conditions and the following disclaimer.
//  2. Redistributions in binary form must reproduce the above copyright
//     notice, this list of conditions and the following disclaimer in the
//     documentation and/or other materials provided with the distribution.
//  3. The names of the authors and copyright holders may not be used to
//     endorse or promote products derived from this software without
//     specific prior written permission.
//
//  IN NO EVENT SHALL DANIEL W. MCROBB BE LIABLE TO ANY PARTY FOR
//  DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES,
//  INCLUDING LOST PROFITS, ARISING OUT OF THE USE OF THIS SOFTWARE,
//  EVEN IF DANIEL W. MCROBB HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH
//  DAMAGE.
//
//  THE SOFTWARE PROVIDED HEREIN IS ON AN "AS IS" BASIS, AND
//  DANIEL W. MCROBB HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT,
//  UPDATES, ENHANCEMENTS, OR MODIFICATIONS. DANIEL W. MCROBB MAKES NO
//  REPRESENTATIONS AND EXTENDS NO WARRANTIES OF ANY KIND, EITHER
//  IMPLIED OR EXPRESS, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
//  WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE,
//  OR THAT THE USE OF THIS SOFTWARE WILL NOT INFRINGE ANY PATENT,
//  TRADEMARK OR OTHER RIGHTS.
//===========================================================================

//---------------------------------------------------------------------------
//!  \file main.cc
//!  \author Daniel W. McRobb
//!  \brief NOT YET DOCUMENTED
//---------------------------------------------------------------------------

#include <QApplication>
#include <QtWebEngine/QtWebEngine>

#include "DwmSvnTag.hh"
#include "DwmSysLogger.hh"
#include "DwmCredencePeer.hh"
#include "DwmMcweatherWeatherdRequest.hh"
#include "DwmMcroverAlertDataModel.hh"
#include "DwmMcroverAlertTableView.hh"
#include "DwmMcroverAlertFetcher.hh"
#include "DwmMcroverWeatherFetcher.hh"
#include "DwmMcroverMinuteEmitter.hh"
#include "DwmMcroverUserLastActiveFilter.hh"
#include "ui_qmcrover.h"

using Dwm::Mcrover::AlertTableView, Dwm::Mcrover::AlertFetcher,
  Dwm::Mcrover::AlertDataModel, Dwm::Mcrover::Config, Dwm::Mcrover::WeatherFetcher,
  Dwm::Mcrover::PeriodForecastsWidget, Dwm::Mcrover::PageButton,
  Dwm::Mcrover::StackedWidget, Dwm::Mcrover::CalendarWidget,
  Dwm::Mcrover::MinuteEmitter, Dwm::Mcrover::WeatherPageWidget,
  Dwm::Mcrover::CurrentWeatherWidgetPair, Dwm::Mcrover::NWSRadarPageWidget;

static const Dwm::SvnTag svntag("@(#) $DwmPath: dwm/mcplex/mcrover/tags/mcrover-0.1.1/apps/qmcrover/main.cc 12048 $");

static AlertFetcher   *g_alertFetcher = nullptr;
static WeatherFetcher *g_weatherFetcher = nullptr;
static MinuteEmitter  *g_minuteEmitter = nullptr;

//----------------------------------------------------------------------------
//!  
//----------------------------------------------------------------------------
static void SetRadarURL(NWSRadarPageWidget *nwsRadar,
                        const Dwm::Mcrover::WeatherConfig & wcfg)
{
  Dwm::Credence::Peer       weatherd;
  if (weatherd.Connect(wcfg.Host(), wcfg.Port())) {
    Dwm::Credence::KeyStash   keyStash;
    Dwm::Credence::KnownKeys  knownKeys;
    if (weatherd.Authenticate(keyStash, knownKeys)) {
      uint8_t  req = Dwm::Mcweather::e_nwsRadarUrl;
      if (weatherd.Send(req)) {
        std::string  radarUrl;
        if (weatherd.Receive(radarUrl)) {
          req = Dwm::Mcweather::e_buhBye;
          weatherd.Send(req);
          nwsRadar->SetURL(radarUrl);
        }
        else {
          Syslog(LOG_ERR, "Failed to receive radar URL");
        }
      }
      else {
        Syslog(LOG_ERR, "Failed to send radar URL request");
      }
    }
    else {
      Syslog(LOG_ERR, "Failed to authenticate to weatherd at %s:%hu",
             wcfg.Host().c_str(), wcfg.Port());
    }
  }
  else {
    Syslog(LOG_ERR, "Failed to connect to weatherd at %s:%hu",
           wcfg.Host().c_str(), wcfg.Port());
  }
  return;
}

//----------------------------------------------------------------------------
//!  
//----------------------------------------------------------------------------
void StopThreads()
{
  Syslog(LOG_INFO, "StopThreads() called");
  exit(0);
  
  g_weatherFetcher->Stop();
  g_minuteEmitter->Stop();
  g_alertFetcher->Stop();
}

//----------------------------------------------------------------------------
//!  
//----------------------------------------------------------------------------
int main(int argc, char *argv[])
{
  QApplication  app(argc, argv);
  QtWebEngine::initialize();

  Dwm::SysLogger::Open("qmcrover", LOG_PID|LOG_PERROR, LOG_LOCAL0);

  QMainWindow  *mainWindow = new QMainWindow();
  Ui_MainWindow  *myMain = new Ui_MainWindow();
  myMain->setupUi(mainWindow);
  mainWindow->setWindowTitle("qmcrover");

  // AlertTableView  *alertView = new AlertTableView();
  AlertDataModel  *alertModel = new AlertDataModel();
  myMain->alertTableView->setModel(alertModel);

  Config  config;
  if (config.Parse("/usr/local/etc/mcroverd.cfg")) {
    AlertFetcher  fetcher(config);
    g_alertFetcher = &fetcher;
    QObject::connect(&fetcher, &AlertFetcher::newAlerts,
                     alertModel, &AlertDataModel::newAlerts);
    QObject::connect(&fetcher, &AlertFetcher::newAlerts,
                     myMain->stackedWidget, &StackedWidget::newAlerts);
    QObject::connect(&fetcher, &AlertFetcher::noAlerts,
                     myMain->stackedWidget, &StackedWidget::noAlerts);
    QObject::connect(&fetcher, &AlertFetcher::newPeer,
                     myMain->currenrPeerLabel, &QLabel::setText);

    WeatherFetcher  weatherFetcher(config);
    g_weatherFetcher = &weatherFetcher;
    if (! QObject::connect(&weatherFetcher, &WeatherFetcher::newForecasts,
                           myMain->weatherPageWidget->Forecasts(),
                           &PeriodForecastsWidget::Populate,
                           Qt::QueuedConnection)) {
      abort();
    }

    SetRadarURL(myMain->nwsRadar, config.Weather());

    //    myMain->pageButton->setImage(QImage(":/resources/images/dwm_orange_no_margins.svg"));
        myMain->pageButton->setImage(QImage(":/resources/images/mcrover_mcplex_orange_base.svg"));
    
    QObject::connect(myMain->pageButton, &PageButton::pressedLeft,
                     myMain->stackedWidget, &StackedWidget::prevPage);
    QObject::connect(myMain->pageButton, &PageButton::pressedRight,
                     myMain->stackedWidget, &StackedWidget::nextPage);

    MinuteEmitter  minuteEmitter;
    g_minuteEmitter = &minuteEmitter;
    QObject::connect(&minuteEmitter, &MinuteEmitter::newMinute,
                     myMain->calendarWidget, &CalendarWidget::Update);

    QObject::connect(myMain->stackedWidget, &StackedWidget::pageChanged,
                     myMain->weatherPageWidget, &WeatherPageWidget::pageChanged);

    QObject::connect(myMain->stackedWidget, &StackedWidget::pageChanged,
                     myMain->nwsRadar, &NWSRadarPageWidget::TweakPage,
                     Qt::QueuedConnection);
    
    QObject::connect(&weatherFetcher, &WeatherFetcher::currentConditions,
                     myMain->currentWeather, &CurrentWeatherWidgetPair::Populate,
                     Qt::QueuedConnection);

    QObject::connect(&app, &QApplication::lastWindowClosed,
                     StopThreads);
    
    myMain->statusbar->showMessage("mcrover");
    
    mainWindow->show();
    fetcher.Start();
    weatherFetcher.Start();
    minuteEmitter.Start();

    Dwm::Mcrover::UserLastActiveFilter  userActivityFilter;
    app.installEventFilter(&userActivityFilter);

    return app.exec();
  }
}
