//===========================================================================
// @(#) $DwmPath: dwm/mcplex/mcrover/tags/mcrover-0.1.1/apps/qmcrover/DwmMcroverMinuteEmitter.cc 10997 $
// @(#) $Id: DwmMcroverMinuteEmitter.cc 10997 2020-08-27 05:34:16Z dwm $
//===========================================================================
//  Copyright (c) Daniel W. McRobb 2020
//  All rights reserved.
//
//  Redistribution and use in source and binary forms, with or without
//  modification, are permitted provided that the following conditions
//  are met:
//
//  1. Redistributions of source code must retain the above copyright
//     notice, this list of conditions and the following disclaimer.
//  2. Redistributions in binary form must reproduce the above copyright
//     notice, this list of conditions and the following disclaimer in the
//     documentation and/or other materials provided with the distribution.
//  3. The names of the authors and copyright holders may not be used to
//     endorse or promote products derived from this software without
//     specific prior written permission.
//
//  IN NO EVENT SHALL DANIEL W. MCROBB BE LIABLE TO ANY PARTY FOR
//  DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES,
//  INCLUDING LOST PROFITS, ARISING OUT OF THE USE OF THIS SOFTWARE,
//  EVEN IF DANIEL W. MCROBB HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH
//  DAMAGE.
//
//  THE SOFTWARE PROVIDED HEREIN IS ON AN "AS IS" BASIS, AND
//  DANIEL W. MCROBB HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT,
//  UPDATES, ENHANCEMENTS, OR MODIFICATIONS. DANIEL W. MCROBB MAKES NO
//  REPRESENTATIONS AND EXTENDS NO WARRANTIES OF ANY KIND, EITHER
//  IMPLIED OR EXPRESS, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
//  WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE,
//  OR THAT THE USE OF THIS SOFTWARE WILL NOT INFRINGE ANY PATENT,
//  TRADEMARK OR OTHER RIGHTS.
//===========================================================================

//---------------------------------------------------------------------------
//!  \file DwmMcroverMinuteEmitter.cc
//!  \author Daniel W. McRobb
//!  \brief NOT YET DOCUMENTED
//---------------------------------------------------------------------------

#include "DwmSvnTag.hh"
#include "DwmSysLogger.hh"
#include "DwmMcroverMinuteEmitter.hh"

static const Dwm::SvnTag svntag("@(#) $DwmPath: dwm/mcplex/mcrover/tags/mcrover-0.1.1/apps/qmcrover/DwmMcroverMinuteEmitter.cc 10997 $");

namespace Dwm {

  namespace Mcrover {

    using namespace std;
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    MinuteEmitter::MinuteEmitter()
        : QObject(), _run(false), _runmtx(),
          _runcv(), _thread()
    {
    }

    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    MinuteEmitter::~MinuteEmitter()
    {
      Stop();
    }
      
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    bool MinuteEmitter::Start()
    {
      bool  rc = false;
      _run = true;
      try { 
        _thread = std::thread(&MinuteEmitter::Run, this);
        rc = true;
      }
      catch (...) {
        Syslog(LOG_ERR, "Exception starting MinuteEmitter thread");
      }
      return rc;
    }
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    bool MinuteEmitter::Stop()
    {
      lock_guard<mutex>  lk(_runmtx);
      _run = false;
      _runcv.notify_one();
      if (_thread.joinable()) {
        _thread.join();
        Syslog(LOG_INFO, "MinuteEmitter thread joined.");
      }
      return true;
    }

    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    void MinuteEmitter::Run()
    {
      bool      keepRunning = true;
      string    curHost;
      uint64_t  intervals = 0;
      Syslog(LOG_INFO, "MinuteEmitter thread started");
      while (keepRunning) {
        emit new5Seconds();
        if ((intervals % 20) == 0) {
          emit newMinute();
        }
        {
          unique_lock<mutex>  lk(_runmtx);
          if (_runcv.wait_for(lk, 5s) != std::cv_status::timeout) {
            keepRunning = _run;
          }
          else {
            ++intervals;
          }
        }
      }
      Syslog(LOG_INFO, "MinuteEmitter thread done");
      
      return;
    }
    

  }  // namespace Mcrover

}  // namespace Dwm
