//===========================================================================
// @(#) $DwmPath: dwm/mcplex/mcrover/tags/mcrover-0.1.1/apps/mcrover/DwmMcroverCalvin1.cc 10997 $
// @(#) $Id: DwmMcroverCalvin1.cc 10997 2020-08-27 05:34:16Z dwm $
//===========================================================================
//  Copyright (c) Daniel W. McRobb 2020
//  All rights reserved.
//
//  Redistribution and use in source and binary forms, with or without
//  modification, are permitted provided that the following conditions
//  are met:
//
//  1. Redistributions of source code must retain the above copyright
//     notice, this list of conditions and the following disclaimer.
//  2. Redistributions in binary form must reproduce the above copyright
//     notice, this list of conditions and the following disclaimer in the
//     documentation and/or other materials provided with the distribution.
//  3. The names of the authors and copyright holders may not be used to
//     endorse or promote products derived from this software without
//     specific prior written permission.
//
//  IN NO EVENT SHALL DANIEL W. MCROBB BE LIABLE TO ANY PARTY FOR
//  DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES,
//  INCLUDING LOST PROFITS, ARISING OUT OF THE USE OF THIS SOFTWARE,
//  EVEN IF DANIEL W. MCROBB HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH
//  DAMAGE.
//
//  THE SOFTWARE PROVIDED HEREIN IS ON AN "AS IS" BASIS, AND
//  DANIEL W. MCROBB HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT,
//  UPDATES, ENHANCEMENTS, OR MODIFICATIONS. DANIEL W. MCROBB MAKES NO
//  REPRESENTATIONS AND EXTENDS NO WARRANTIES OF ANY KIND, EITHER
//  IMPLIED OR EXPRESS, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
//  WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE,
//  OR THAT THE USE OF THIS SOFTWARE WILL NOT INFRINGE ANY PATENT,
//  TRADEMARK OR OTHER RIGHTS.
//===========================================================================

//---------------------------------------------------------------------------
//!  \file DwmMcroverCalvin1.cc
//!  \author Daniel W. McRobb
//!  \brief NOT YET DOCUMENTED
//---------------------------------------------------------------------------

#include <algorithm>
#include <cstring>
#include <vector>

#include "DwmMcroverCalvin1.hh"
#include "DwmMcroverColorPairs.hh"

namespace Dwm {

  namespace Mcrover {

    using namespace std;
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    static const vector<string> g_calvin1 = {
      R"(                           o$o)",
      R"(                           $  "o        o$o)",
      R"(            o              $    "o     o" "o   o)",
      R"(            "$$"""ooooo    $      "o  o"   "o $ $  $)",
      R"(              "$oo    ""$o $        "o"     "o" "o $      oo)",
      R"(                 """oo   ""$o        ""      "   "o$o oo""  $)",
      R"(                     "$oo   "                   $"" ""   ooo$)",
      R"(             ooooooooo    oooooo""""           $   o       """"oo)",
      R"(    """""""""        ""                        $   $$  $  "ooo  $)",
      R"(            o                          """oo  $   o" $o"$   $ "")",
      R"(    oooooo$"$""""""                    ooo   o"   $     "ooo")",
      R"(            $                             " o$   $)",
      R"(            $                         ooo$$$$"  o"""o)",
      R"(            $          ooooooo  ooo$$$"""o$"$   $   $)",
      R"(            "o      oo$"ooooo$$$"""   oooo o"  o"   $)",
      R"(            o$o"""$o$$$"""$$$$$      o"   """""$oo$")",
      R"(           $oo$$$"$$"$$   $$$$$      $oo           "$")",
      R"(           $$$$$  $$o$$$$$$$$"      $   """"oooo   o")",
      R"(            $$$$$$$"   """""  oo    $o          ""$)",
      R"(             "$"" $            $   $  """oo      $)",
      R"(              $   ""ooo""     o"  o""oo    """oo")",
      R"(              $            oo"    $    """oo  o")",
      R"(    oooooo    $       """""      ""oo       $")",
      R"(o"""     ""o   $oo       ooooo"""    """oo  $)",
      R"($oo"" o"   "o     "$$$"""     """ooo      $")",
      R"(o"   $   $  "o   o"o  """oooo       ""oo  $)",
      R"($   $$  o"o  "o $ $          """ooo     "$)",
      R"( """  ""  $    ""o$                """"oo")",
      R"(           $   o $"""""""""""ooooooo    $)",
      R"(            "o" o"                 ""$o$)",
      R"(                $""""""""""$oooo       $)",
      R"(                $              """$oo  $)",
      R"(                $"""""""oooooooooo  """$)",
      R"(                $                 """oo$)",
      R"(                $""""""""""""""""oooo  $)",
      R"(                 $   oooooooooooo    "o $)",
      R"(                 $"""oooooooooooo""""oo$$oo)",
      R"(                  o$$$$$$$$$$$$$$$$$$o$$$$$o$""$o)",
      R"(                  $$$$$$$$$$$$$$$$$$$$$$$$$$o   $)",
      R"(                   "$$$$$$$$$$$$$$$$$$$$$$" o"  $)",
      R"(                      "$$$$$$$$$$$$$$$$$$"o"  o$)",
      R"(                       $"ooooo"""$"oooooo"   "")",
      R"(                        $       $          $)",
      R"(                         $o      $o      o")",
      R"(          $$$$$$$$$$$$$$$$"$ooo$"" "ooo""$$$$$$$$$$$$$$$$$$$$$$$$$")"
    };

    static const vector<string> g_calvinmask1 = {
      R"(                           yyy)",
      R"(                           y  yy        yyy)",
      R"(            y              y    yy     yy yy   y)",
      R"(            yyyyyyyyyyy    y      yy  yy   yy y y  y)",
      R"(              yyyy    yyyy y        yyy     yyy yy y      ff)",
      R"(                 yyyyy   yyyy        yy      y   yyyy ffff  f)",
      R"(                     yyyy   y                   fff ff   ffff)",
      R"(             yyyyyyyyy    yyyyyyyyyy           f   f       ffffff)",
      R"(    yyyyyyyyy        yy                        f   ff  f  ffff  f)",
      R"(            f                          yyyyy  f   ff ffff   f ff)",
      R"(    yyyyyyyyyyyyyyy                    yyyy  ff   f     fffff)",
      R"(            f                             r ff   f)",
      R"(            f                         rrrrrrff  frrrr)",
      R"(            f          ooooooo  ooo$$$rrrrrff   f   r)",
      R"(            ff      oo$"ooooo$$$"""   rrrr ff  fr   r)",
      R"(            o$o"""$o$$$"""$$$$$      rr   rrrrrrrrrr)",
      R"(           $oo$$$"$$"$$   $$$$$      rrr           rrr)",
      R"(           $$$$$  $$o$$$$$$$$"      r   rrrrrrrr   rr)",
      R"(            $$$$$$$"   """""  ff    rr          rrr)",
      R"(             "$"" f            f   r  rrrrr      r)",
      R"(              f   fffffff     ff  rrrrr    rrrrrr)",
      R"(              f            fff    r    rrrrr  rr)",
      R"(    ffffff    f       fffff      rrrr       rr)",
      R"(ffff     fff   fff       fffffrrr    rrrrr  r)",
      R"(fffff ff   ff     fffffff     rrrrrr      rr)",
      R"(ff   f   f  ff   rrr  rrrrrrr       rrrr  r)",
      R"(f   ff  fff  ff r r          rrrrrr     rr)",
      R"( fff  ff  f    ffrr                rrrrrrr)",
      R"(           f   f rrrrrrrrrrrrrrrrrrr    r)",
      R"(            fff rr                 rrrrr)",
      R"(                rrrrrrrrrrrrrrrr       r)",
      R"(                r              rrrrrr  r)",
      R"(                rrrrrrrrrrrrrrrrrr  rrrr)",
      R"(                r                 rrrrrr)",
      R"(                rrrrrrrrrrrrrrrrrrrrr  r)",
      R"(                 b   bbbbbbbbbbbb    bb b)",
      R"(                 bbbbbbbbbbbbbbbbbbbbbbbbbb)",
      R"(                  bbbbbbbbbbbbbbbbbbbbbbbbbbwwwww)",
      R"(                  bbbbbbbbbbbbbbbbbbbbbbbbbww   w)",
      R"(                   bbbbbbbbbbbbbbbbbbbbbbbw ww  w)",
      R"(                      bbbbbbbbbbbbbbbbbbbwww  ww)",
      R"(                       wwwwwwwwwwwwwwwwwww   ww)",
      R"(                        w       w          w)",
      R"(                         ww      ww      ww)",
      R"(          ggggggggggggggggwwwwwwww wwwwwwggggggggggggggggggggggggg")"
    };
    
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    int Calvin1::Width() const
    {
      return max_element(g_calvin1.begin(), g_calvin1.end(),
                         [] (const string & a, const string & b)
                         { return (a.size() < b.size()); })->size();
    }

    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    int Calvin1::Height() const
    {
      return g_calvin1.size();
    }
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    void Calvin1::Draw(WINDOW *win) const
    {
      if (win) {
        auto [origy, origx] = Position(win);
        int  white = ColorPairs::Pair("white");
        wattrset(win, COLOR_PAIR(white)|A_BOLD);
        for (int ln = 0; ln < g_calvin1.size(); ++ln) {
          mvwaddstr(win, origy + ln, origx, g_calvin1[ln].c_str());
          wclrtoeol(win);
        }

        if (has_colors()) {
          std::unordered_map<char,int> cm;
          if (COLORS > 8) {
            cm = {
              { 'y', ColorPairs::Pair("brightyellow") },
              { 'f', ColorPairs::Pair("wheat1") },
              { 'r', ColorPairs::Pair("brightred") },
              { 'b', ColorPairs::Pair("skyblue") },
              { 'w', ColorPairs::Pair("white") },
              { 'g', ColorPairs::Pair("green") }
            };
          }
          else {
            cm = {
              { 'y', ColorPairs::Pair("yellow") },
              { 'f', ColorPairs::Pair("white") },
              { 'r', ColorPairs::Pair("red") },
              { 'b', ColorPairs::Pair("blue") },
              { 'w', ColorPairs::Pair("cyan") },
              { 'g', ColorPairs::Pair("green") }
            };
          }
          
          for (int ln = 0; ln < g_calvinmask1.size(); ++ln) {
            int  wid = g_calvinmask1[ln].size();
            for (int cn = 0; cn < wid; ++cn) {
              if (' ' != g_calvinmask1[ln][cn]) {
                auto  it = cm.find(g_calvinmask1[ln][cn]);
                if (it != cm.end()) {
                  mvwchgat(win, origy+ln, origx+cn, 1, A_NORMAL, it->second,
                           nullptr);
                }
              }
            }
          }
          
          mvwchgat(win, origy+g_calvin1.size(), origx, -1, A_NORMAL,
                   white, nullptr);
        }
      }
      return;
    }
    
    
  }  // namespace Mcrover
  
}  // namespace Dwm
