//===========================================================================
// @(#) $DwmPath: dwm/mcplex/mcrover/tags/mcrover-0.1.12/classes/tests/TestAlertOrigin.cc 10997 $
// @(#) $Id: TestAlertOrigin.cc 10997 2020-08-27 05:34:16Z dwm $
//===========================================================================
//  Copyright (c) Daniel W. McRobb 2020
//  All rights reserved.
//
//  Redistribution and use in source and binary forms, with or without
//  modification, are permitted provided that the following conditions
//  are met:
//
//  1. Redistributions of source code must retain the above copyright
//     notice, this list of conditions and the following disclaimer.
//  2. Redistributions in binary form must reproduce the above copyright
//     notice, this list of conditions and the following disclaimer in the
//     documentation and/or other materials provided with the distribution.
//  3. The names of the authors and copyright holders may not be used to
//     endorse or promote products derived from this software without
//     specific prior written permission.
//
//  IN NO EVENT SHALL DANIEL W. MCROBB BE LIABLE TO ANY PARTY FOR
//  DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES,
//  INCLUDING LOST PROFITS, ARISING OUT OF THE USE OF THIS SOFTWARE,
//  EVEN IF DANIEL W. MCROBB HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH
//  DAMAGE.
//
//  THE SOFTWARE PROVIDED HEREIN IS ON AN "AS IS" BASIS, AND
//  DANIEL W. MCROBB HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT,
//  UPDATES, ENHANCEMENTS, OR MODIFICATIONS. DANIEL W. MCROBB MAKES NO
//  REPRESENTATIONS AND EXTENDS NO WARRANTIES OF ANY KIND, EITHER
//  IMPLIED OR EXPRESS, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
//  WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE,
//  OR THAT THE USE OF THIS SOFTWARE WILL NOT INFRINGE ANY PATENT,
//  TRADEMARK OR OTHER RIGHTS.
//===========================================================================

//---------------------------------------------------------------------------
//!  \file TestAlertOrigin.cc
//!  \author Daniel W. McRobb
//!  \brief unit tests for Dwm::Mcrover::AlertOrigin
//---------------------------------------------------------------------------

extern "C" {
  #include <fcntl.h>
  #include <unistd.h>
}

#include <iostream>
#include <sstream>

#include "DwmUnitAssert.hh"
#include "DwmMcroverAlertOrigin.hh"
#include "DwmMcroverUnitTestUtils.hh"

using namespace std;
using namespace Dwm;

#define MY_IOTESTFILE "./TestAlertOrigin.tmp"

//----------------------------------------------------------------------------
//!  
//----------------------------------------------------------------------------
static void TestAccessors()
{
  using Mcrover::AlertOrigin;

  AlertOrigin  origin("dwm", Dwm::Ipv4Address("192.168.0.1"));
  UnitAssert(origin.PackName() == "dwm");
  UnitAssert(origin.MemberAddress() == Dwm::Ipv4Address("192.168.0.1"));
  
  UnitAssert(origin.PackName("whatever") == "whatever");
  UnitAssert(origin.PackName() == "whatever");
  UnitAssert(origin.MemberAddress(Dwm::Ipv4Address("127.0.0.1"))
             == Dwm::Ipv4Address("127.0.0.1"));
  UnitAssert(origin.MemberAddress() == Dwm::Ipv4Address("127.0.0.1"));
  
  return;
}

//----------------------------------------------------------------------------
//!  
//----------------------------------------------------------------------------
static void TestBasicIO()
{
  using Mcrover::AlertOrigin;
  
  AlertOrigin origin("somepack", Dwm::Ipv4Address("10.1.3.1"));
  Mcrover::UnitTestUtils::TestBasicStreamIO(origin);
  Mcrover::UnitTestUtils::TestBasicFileIO(origin, MY_IOTESTFILE);
  Mcrover::UnitTestUtils::TestBasicDescriptorIO(origin, MY_IOTESTFILE);
  return;
}
      
//----------------------------------------------------------------------------
//!  
//----------------------------------------------------------------------------
int main(int argc, char *argv[])
{
  TestAccessors();
  TestBasicIO();
  
  if (Assertions::Total().Failed()) {
    Assertions::Print(cerr, true);
  }
  else {
    cout << Assertions::Total() << " passed" << endl;
  }
  
}
