//===========================================================================
// @(#) $DwmPath: dwm/mcplex/mcrover/tags/mcrover-0.1.12/classes/src/DwmMcroverDiskUtils.cc 11340 $
// @(#) $Id: DwmMcroverDiskUtils.cc 11340 2020-12-05 04:49:14Z dwm $
//===========================================================================
//  Copyright (c) Daniel W. McRobb 2020
//  All rights reserved.
//
//  Redistribution and use in source and binary forms, with or without
//  modification, are permitted provided that the following conditions
//  are met:
//
//  1. Redistributions of source code must retain the above copyright
//     notice, this list of conditions and the following disclaimer.
//  2. Redistributions in binary form must reproduce the above copyright
//     notice, this list of conditions and the following disclaimer in the
//     documentation and/or other materials provided with the distribution.
//  3. The names of the authors and copyright holders may not be used to
//     endorse or promote products derived from this software without
//     specific prior written permission.
//
//  IN NO EVENT SHALL DANIEL W. MCROBB BE LIABLE TO ANY PARTY FOR
//  DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES,
//  INCLUDING LOST PROFITS, ARISING OUT OF THE USE OF THIS SOFTWARE,
//  EVEN IF DANIEL W. MCROBB HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH
//  DAMAGE.
//
//  THE SOFTWARE PROVIDED HEREIN IS ON AN "AS IS" BASIS, AND
//  DANIEL W. MCROBB HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT,
//  UPDATES, ENHANCEMENTS, OR MODIFICATIONS. DANIEL W. MCROBB MAKES NO
//  REPRESENTATIONS AND EXTENDS NO WARRANTIES OF ANY KIND, EITHER
//  IMPLIED OR EXPRESS, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
//  WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE,
//  OR THAT THE USE OF THIS SOFTWARE WILL NOT INFRINGE ANY PATENT,
//  TRADEMARK OR OTHER RIGHTS.
//===========================================================================

//---------------------------------------------------------------------------
//!  \file DwmMcroverDiskUtils.cc
//!  \author Daniel W. McRobb
//!  \brief NOT YET DOCUMENTED
//---------------------------------------------------------------------------

#include <cstdio>
#include <nlohmann/json.hpp>

#include "DwmSvnTag.hh"
#include "DwmSysLogger.hh"
#include "DwmMcroverDiskAlert.hh"
#include "DwmMcroverDiskUtils.hh"
#include "DwmMcroverUtils.hh"

static const Dwm::SvnTag svntag("@(#) $DwmPath: dwm/mcplex/mcrover/tags/mcrover-0.1.12/classes/src/DwmMcroverDiskUtils.cc 11340 $");

namespace Dwm {

  namespace Mcrover {

    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    static std::string GetHealthJsonAsString(const std::string & devicePath)
    {
      std::string  rc;
      std::string  cmd("smartctl -j -H ");
      cmd += devicePath;
      FILE  *p = popen(cmd.c_str(), "r");
      if (p) {
        char  buf[4096];
        while (! feof(p)) {
          memset(buf, 0, sizeof(buf));
          size_t  bytesRead = fread(buf, 1, sizeof(buf), p);
          if (bytesRead) {
            rc += buf;
          }
          else {
            break;
          }
        }
        pclose(p);
      }
      else {
        Syslog(LOG_ERR, "popen(\"%s\",\"r\") failed", cmd.c_str());
      }
      return rc;
    }
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    static bool DiskIsHealthy(const std::string & devicePath)
    {
      using nlohmann::json;
      
      bool  rc = false;
      std::string  resultStr = GetHealthJsonAsString(devicePath);
      if (! resultStr.empty()) {
        auto  j = json::parse(resultStr);
        if (j.is_object()) {
          auto  smart_status = j.find("smart_status");
          if ((smart_status != j.end()) && (smart_status->is_object())) {
            auto  passed = smart_status->find("passed");
            if ((passed != smart_status->end()) && (passed->is_boolean())) {
              rc = passed->get<bool>();
              if (rc) {
                Syslog(LOG_INFO, "SMART health passed for %s",
                       devicePath.c_str());
              }
              else {
                Syslog(LOG_CRIT, "SMART health failed for %s!!!",
                       devicePath.c_str());
              }
            }
            else { Syslog(LOG_ERR, "'passed' not found in SMART JSON"); }
          }
          else { Syslog(LOG_ERR, "'smart_status' not found in SMART JSON"); }
        }
        else { Syslog(LOG_ERR, "Invalid SMART JSON"); }
      }
      else { Syslog(LOG_ERR, "SMART JSON is empty"); }
      
      return rc;
    }

    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    bool DiskUtils::GetAlerts(const AlertOrigin & origin,
                              const LocalHostConfig & local,
                              AlertBowl & alerts, bool clearAtEntry)
    {
      if (clearAtEntry) {
        alerts.Clear();
      }
      Ipv4Address  localAddr(Utils::ThisHostIpv4Addr());
      for (const auto disk : local.Disks()) {
        if (! DiskIsHealthy(disk.second)) {
          Syslog(LOG_CRIT, "Disk %s (%s) health failed!!!",
                 disk.second.c_str(), disk.first.c_str());
          alerts.Add(origin, DiskAlert(localAddr, disk), time((time_t *)0));
        }
      }
      return (! alerts.Empty());
    }
    
    
  }  // namespace Mcrover

}  // namespace Dwm
