//===========================================================================
// @(#) $Name$
// @(#) $Id: DumpDates.hh 1128 2004-04-06 16:14:25Z dwm $
//===========================================================================
//  Copyright (c) Daniel W. McRobb 2002, 2023
//  All rights reserved.
//
//  Daniel W. McRobb <dwm@mcplex.net>
//===========================================================================

#ifndef _DUMPDATES_HH_
#define _DUMPDATES_HH_

extern "C" {
  #include <time.h>
}

#include <map>
#include <string>

namespace Dwm {

  namespace Mcrover {
    
    //------------------------------------------------------------------------
    //!  Encapsulates /etc/dumpdates information.
    //------------------------------------------------------------------------
    class DumpDates
    {
    public:
      //----------------------------------------------------------------------
      //!  Construct from a file in the form of /etc/dumpdates.  If
      //!  @c fileName is empty, use the path we think is used by 'dump'.
      //!  On Linux that's "/var/lib/dumpdates".  On other OSes we assume
      //!  it's "/etc/dumpdates" as on FreeBSD.
      //----------------------------------------------------------------------
      DumpDates(const std::string & fileName = "");
      
      //----------------------------------------------------------------------
      //!  Returns the last time that fs was dumped at a given level.
      //----------------------------------------------------------------------
      time_t LastDumpAtLevel(const std::string & fs, int level) const;

      //----------------------------------------------------------------------
      //!  Returns the last dump level and time.
      //----------------------------------------------------------------------
      std::pair<int,time_t> LastDump(const std::string & fs) const;

      //----------------------------------------------------------------------
      //!  Prints to an ostream.
      //----------------------------------------------------------------------
      friend std::ostream & operator << (std::ostream & os, 
					 const DumpDates & dd);
      
    private:
      std::map<std::string,std::map<int,time_t> > _data;
    };
    
  }  // namespace Mcrover

}  // namespace Dwm
  
#endif  // _DUMPDATES_HH_
