//===========================================================================
// @(#) $DwmPath: dwm/mcplex/mcrover/tags/mcrover-0.1.12/apps/rpctest/rpctest.cc 11360 $
// @(#) $Id: rpctest.cc 11360 2020-12-09 01:49:31Z dwm $
//===========================================================================
//  Copyright (c) Daniel W. McRobb 2020
//  All rights reserved.
//
//  Redistribution and use in source and binary forms, with or without
//  modification, are permitted provided that the following conditions
//  are met:
//
//  1. Redistributions of source code must retain the above copyright
//     notice, this list of conditions and the following disclaimer.
//  2. Redistributions in binary form must reproduce the above copyright
//     notice, this list of conditions and the following disclaimer in the
//     documentation and/or other materials provided with the distribution.
//  3. The names of the authors and copyright holders may not be used to
//     endorse or promote products derived from this software without
//     specific prior written permission.
//
//  IN NO EVENT SHALL DANIEL W. MCROBB BE LIABLE TO ANY PARTY FOR
//  DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES,
//  INCLUDING LOST PROFITS, ARISING OUT OF THE USE OF THIS SOFTWARE,
//  EVEN IF DANIEL W. MCROBB HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH
//  DAMAGE.
//
//  THE SOFTWARE PROVIDED HEREIN IS ON AN "AS IS" BASIS, AND
//  DANIEL W. MCROBB HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT,
//  UPDATES, ENHANCEMENTS, OR MODIFICATIONS. DANIEL W. MCROBB MAKES NO
//  REPRESENTATIONS AND EXTENDS NO WARRANTIES OF ANY KIND, EITHER
//  IMPLIED OR EXPRESS, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
//  WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE,
//  OR THAT THE USE OF THIS SOFTWARE WILL NOT INFRINGE ANY PATENT,
//  TRADEMARK OR OTHER RIGHTS.
//===========================================================================

//---------------------------------------------------------------------------
//!  \file mailtest.cc
//!  \author Daniel W. McRobb
//!  \brief NOT YET DOCUMENTED
//---------------------------------------------------------------------------

extern "C" {
  #include <limits.h>
  #include <unistd.h>
}

#include <cstdlib>
#include <fstream>
#include <iomanip>
#include <iostream>

#include "DwmSysLogger.hh"
#include "DwmMcroverRPCUtils.hh"
#include "DwmMcroverConfig.hh"
#include "DwmMcroverRPCAlert.hh"

using namespace std;
using Dwm::Mcrover::RPCProgramId, Dwm::Mcrover::RPCTarget, Dwm::Mcrover::RPCUtils;
using Dwm::Mcrover::AlertBowl, Dwm::Mcrover::AlertOrigin, Dwm::Mcrover::Config;

//----------------------------------------------------------------------------
//!  
//----------------------------------------------------------------------------
int main(int argc, char *argv[])
{
  int  rc = 1;

  if (argc == 2) {
    Dwm::SysLogger::Open("rpctest", LOG_PERROR, LOG_USER);
    Dwm::SysLogger::MinimumPriority(LOG_INFO);
    Config  config;
    if (config.Parse(argv[1])) {
      AlertOrigin  alertOrigin("mypack", Dwm::Ipv4Address("127.0.0.1"));
      AlertBowl    alertBowl;
      if (! RPCUtils::GetAlerts(alertOrigin, config.Servers(), alertBowl)) {
        rc = 0;
        cout << "No alerts\n";
      }
      else {
        vector<AlertBowl::EntryType>  alerts;
        alertBowl.Get(alerts);
        for (const auto & alert : alerts) {
          cerr << alert.second.DisplayString() << '\n';;
        }
      }
    }
    else {
      cerr << "Failed to parse JSON config in '" << argv[1] << "'\n";
    }
  }
  else {
    cerr << "Usage: " << argv[0] << " configFile\n";
  }
  
  return rc;
}
