//===========================================================================
// @(#) $DwmPath: dwm/mcplex/mcrover/tags/mcrover-0.1.12/apps/qmcrover/DwmMcroverAlertDataModel.cc 10997 $
// @(#) $Id: DwmMcroverAlertDataModel.cc 10997 2020-08-27 05:34:16Z dwm $
//===========================================================================
//  Copyright (c) Daniel W. McRobb 2020
//  All rights reserved.
//
//  Redistribution and use in source and binary forms, with or without
//  modification, are permitted provided that the following conditions
//  are met:
//
//  1. Redistributions of source code must retain the above copyright
//     notice, this list of conditions and the following disclaimer.
//  2. Redistributions in binary form must reproduce the above copyright
//     notice, this list of conditions and the following disclaimer in the
//     documentation and/or other materials provided with the distribution.
//  3. The names of the authors and copyright holders may not be used to
//     endorse or promote products derived from this software without
//     specific prior written permission.
//
//  IN NO EVENT SHALL DANIEL W. MCROBB BE LIABLE TO ANY PARTY FOR
//  DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES,
//  INCLUDING LOST PROFITS, ARISING OUT OF THE USE OF THIS SOFTWARE,
//  EVEN IF DANIEL W. MCROBB HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH
//  DAMAGE.
//
//  THE SOFTWARE PROVIDED HEREIN IS ON AN "AS IS" BASIS, AND
//  DANIEL W. MCROBB HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT,
//  UPDATES, ENHANCEMENTS, OR MODIFICATIONS. DANIEL W. MCROBB MAKES NO
//  REPRESENTATIONS AND EXTENDS NO WARRANTIES OF ANY KIND, EITHER
//  IMPLIED OR EXPRESS, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
//  WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE,
//  OR THAT THE USE OF THIS SOFTWARE WILL NOT INFRINGE ANY PATENT,
//  TRADEMARK OR OTHER RIGHTS.
//===========================================================================

//---------------------------------------------------------------------------
//!  \file DwmMcroverAlertDataModel.cc
//!  \author Daniel W. McRobb
//!  \brief NOT YET DOCUMENTED
//---------------------------------------------------------------------------

#include <QPen>

#include "DwmSvnTag.hh"
#include "DwmSysLogger.hh"
#include "DwmMcroverAlertDataModel.hh"

static const Dwm::SvnTag svntag("@(#) $DwmPath: dwm/mcplex/mcrover/tags/mcrover-0.1.12/apps/qmcrover/DwmMcroverAlertDataModel.cc 10997 $");
namespace Dwm {

  namespace Mcrover {

    using namespace std;
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    int AlertDataModel::rowCount(const QModelIndex & parent) const
    {
      return _alerts.size();
    }
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    int AlertDataModel::columnCount(const QModelIndex & parent) const
    {
      return 1;
    }

    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    QVariant AlertDataModel::headerData(int section,
                                        Qt::Orientation orientation,
                                        int role) const
    {
      QVariant  rc;
      if (orientation == Qt::Horizontal) {
        if (role == Qt::DisplayRole) {
          rc = QString("mcrover");
        }
      }
      return rc;
    }
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    QVariant AlertDataModel::data(const QModelIndex & index, int role) const
    {
      QVariant  rc;
      if (index.row() < _alerts.size()) {
        switch (role) {
          case Qt::DisplayRole:
            {
              string  dispstr = _alerts[index.row()].second.DisplayString() + ' ';
              std::visit([&dispstr](auto const & p)
              { dispstr += p.DisplayString(); }, _alerts[index.row()].first);
              rc = QString(dispstr.c_str());
            }
            break;
          case Qt::ForegroundRole:
            return QPen(Qt::white);
            break;
          default:
            break;
        }
      }
      return rc;
    }
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    void AlertDataModel::
    newAlerts(shared_ptr<std::vector<std::pair<AlertBowl::KeyType,AlertBowlValue>>> alerts)
    {
      beginResetModel();
      _alerts = *alerts;
      endResetModel();
      return;
    }
    
    
  }  // namespace Mcrover

}  // namespace Dwm
