//===========================================================================
// @(#) $DwmPath: dwm/mcplex/mcrover/tags/mcrover-0.1.12/apps/mcrovercat/mcrovercat.cc 10997 $
// @(#) $Id: mcrovercat.cc 10997 2020-08-27 05:34:16Z dwm $
//===========================================================================
//  Copyright (c) Daniel W. McRobb 2020
//  All rights reserved.
//
//  Redistribution and use in source and binary forms, with or without
//  modification, are permitted provided that the following conditions
//  are met:
//
//  1. Redistributions of source code must retain the above copyright
//     notice, this list of conditions and the following disclaimer.
//  2. Redistributions in binary form must reproduce the above copyright
//     notice, this list of conditions and the following disclaimer in the
//     documentation and/or other materials provided with the distribution.
//  3. The names of the authors and copyright holders may not be used to
//     endorse or promote products derived from this software without
//     specific prior written permission.
//
//  IN NO EVENT SHALL DANIEL W. MCROBB BE LIABLE TO ANY PARTY FOR
//  DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES,
//  INCLUDING LOST PROFITS, ARISING OUT OF THE USE OF THIS SOFTWARE,
//  EVEN IF DANIEL W. MCROBB HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH
//  DAMAGE.
//
//  THE SOFTWARE PROVIDED HEREIN IS ON AN "AS IS" BASIS, AND
//  DANIEL W. MCROBB HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT,
//  UPDATES, ENHANCEMENTS, OR MODIFICATIONS. DANIEL W. MCROBB MAKES NO
//  REPRESENTATIONS AND EXTENDS NO WARRANTIES OF ANY KIND, EITHER
//  IMPLIED OR EXPRESS, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
//  WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE,
//  OR THAT THE USE OF THIS SOFTWARE WILL NOT INFRINGE ANY PATENT,
//  TRADEMARK OR OTHER RIGHTS.
//===========================================================================

//---------------------------------------------------------------------------
//!  \file mcrovercat.cc
//!  \author Daniel W. McRobb
//!  \brief NOT YET DOCUMENTED
//---------------------------------------------------------------------------

extern "C" {
  #include <unistd.h>
}

#include <algorithm>

#include "DwmDateTime.hh"
#include "DwmSvnTag.hh"
#include "DwmMcroverAlertBowl.hh"

static const Dwm::SvnTag svntag("@(#) $DwmPath: dwm/mcplex/mcrover/tags/mcrover-0.1.12/apps/mcrovercat/mcrovercat.cc 10997 $");

using namespace std;

//----------------------------------------------------------------------------
//!  
//----------------------------------------------------------------------------
static void Usage(const char *argv0)
{
  std::cerr << "Usage: " << argv0 << " [-s] alertFile [alertFiles ...]\n";
  return;
}

//----------------------------------------------------------------------------
//!  
//----------------------------------------------------------------------------
int main(int argc, char *argv[])
{
  using namespace Dwm;

  bool  shortForm = false;
  
  int  optChar;
  while ((optChar = getopt(argc, argv, "s")) != -1) {
    switch (optChar) {
      case 's':
        shortForm = true;
        break;
      default:
        Usage(argv[0]);
        return -1;
        break;
    }
  }

  if (optind >= argc) {
    Usage(argv[0]);
    return -1;
  }
  
  int  rc = -1;

  for (; optind < argc; ++optind) {
    Mcrover::AlertBowl  alertBowl;
    if (alertBowl.Load(argv[optind])) {
      if (shortForm) {
        vector<pair<time_t,string>>  alerts;
        if (alertBowl.GetConcise(alerts)) {
          sort(alerts.begin(), alerts.end(),
               [] (const auto & al1, const auto & al2)
               { return (al1.first < al2.first); });
          for (const auto & al : alerts) {
            cout << Dwm::DateTime(Dwm::TimeValue64(al.first,0)).Formatted("%m/%d %H:%M ")
                 << ' ' << al.second << '\n';
          }
        }
      }
      else {
        cout << alertBowl;
      }
    }
    else {
      cerr << "Failed to load alerts from '" << argv[optind] << "'\n";
      break;
    }
  }
  if (optind == argc) {
    rc = 0;
  }
  
  return rc;
  
}

