//===========================================================================
// @(#) $DwmPath: dwm/mcplex/mcpigdocomm/tags/mcpigdocomm-0.1.0/src/DwmPiGdoResponseMessage.cc 9758 $
// @(#) $Id: DwmPiGdoResponseMessage.cc 9758 2017-07-07 01:50:12Z dwm $
//===========================================================================
//  Copyright (c) Daniel W. McRobb 2016
//  All rights reserved.
//
//  Redistribution and use in source and binary forms, with or without
//  modification, are permitted provided that the following conditions
//  are met:
//
//  1. Redistributions of source code must retain the above copyright
//     notice, this list of conditions and the following disclaimer.
//  2. Redistributions in binary form must reproduce the above copyright
//     notice, this list of conditions and the following disclaimer in the
//     documentation and/or other materials provided with the distribution.
//  3. The names of the authors and copyright holders may not be used to
//     endorse or promote products derived from this software without
//     specific prior written permission.
//
//  IN NO EVENT SHALL DANIEL W. MCROBB BE LIABLE TO ANY PARTY FOR
//  DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES,
//  INCLUDING LOST PROFITS, ARISING OUT OF THE USE OF THIS SOFTWARE,
//  EVEN IF DANIEL W. MCROBB HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH
//  DAMAGE.
//
//  THE SOFTWARE PROVIDED HEREIN IS ON AN "AS IS" BASIS, AND
//  DANIEL W. MCROBB HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT,
//  UPDATES, ENHANCEMENTS, OR MODIFICATIONS. DANIEL W. MCROBB MAKES NO
//  REPRESENTATIONS AND EXTENDS NO WARRANTIES OF ANY KIND, EITHER
//  IMPLIED OR EXPRESS, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
//  WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE,
//  OR THAT THE USE OF THIS SOFTWARE WILL NOT INFRINGE ANY PATENT,
//  TRADEMARK OR OTHER RIGHTS.
//===========================================================================

//---------------------------------------------------------------------------
//!  \file DwmPiGdoResponseMessage.cc
//!  \brief Dwm::Pi::Gdo::ResponseMessage implementations
//!  \author Daniel W. McRobb \link mailto:dwm@mcplex.net \endlink
//---------------------------------------------------------------------------

extern "C" {
  #include <unistd.h>
}

#include "DwmIO.hh"
#include "DwmSvnTag.hh"
#include "DwmAuthSymCryptoMessage.hh"
#include "DwmPiGdoResponseMessage.hh"

static const Dwm::SvnTag svntag("@(#) $DwmPath: dwm/mcplex/mcpigdocomm/tags/mcpigdocomm-0.1.0/src/DwmPiGdoResponseMessage.cc 9758 $");

using namespace std;

namespace Dwm {

  namespace Pi {

    namespace Gdo {

      //----------------------------------------------------------------------
      //!  
      //----------------------------------------------------------------------
      ResponseMessage::ResponseMessage(const Json::Value & value)
          : _value(value)
      {}
      
      //----------------------------------------------------------------------
      //!  
      //----------------------------------------------------------------------
      const Json::Value & ResponseMessage::Json() const
      {
        return _value;
      }

      //----------------------------------------------------------------------
      //!  
      //----------------------------------------------------------------------
      const Json::Value & ResponseMessage::Json(const Json::Value & value)
      {
        _value = value;
        return _value;
      }
      
      //----------------------------------------------------------------------
      //!  
      //----------------------------------------------------------------------
      bool ResponseMessage::Read(int fd, const string & secret)
      {
        bool  rc = false;
        _value.clear();
        if (fd >= 0) {
          Auth::SymCrypto::Message  msg(secret);
          if (msg.Read(fd) > 0) {
            Json::Reader  jsonReader;
            rc = jsonReader.parse(msg.Value(), _value);
          }
        }
        return rc;
      }

      //----------------------------------------------------------------------
      //!  
      //----------------------------------------------------------------------
      istream & ResponseMessage::Read(istream & is, const string & secret)
      {
        _value.clear();
        if (is) {
          Auth::SymCrypto::Message msg(secret);
          if (msg.Read(is)) {
            Json::Reader  jsonReader;
            jsonReader.parse(msg.Value(), _value);
          }
        }
        return is;
      }
      
      //----------------------------------------------------------------------
      //!  
      //----------------------------------------------------------------------
      bool ResponseMessage::Write(int fd, const string & secret) const
      {
        bool  rc = false;
        if (fd >= 0) {
          Json::FastWriter  fw;
          Auth::SymCrypto::Message  msg(secret, fw.write(_value));
          if (msg.Write(fd) == msg.StreamedLength()) {
            rc = true;
          }
        }
        return rc;
      }

      //----------------------------------------------------------------------
      //!  
      //----------------------------------------------------------------------
      ostream &
      ResponseMessage::Write(ostream & os, const string & secret) const
      {
        if (os) {
          Json::FastWriter  fw;
          Auth::SymCrypto::Message  msg(secret, fw.write(_value));
          msg.Write(os);
        }
        return os;
      }
      
    }  // namespace Gdo

  }  // namespace Pi

}  // namespace Dwm
