//===========================================================================
// @(#) $DwmPath: dwm/mcplex/mcpigdocomm/tags/mcpigdocomm-0.1.0/include/DwmPiGdoResponseMessage.hh 9758 $
// @(#) $Id: DwmPiGdoResponseMessage.hh 9758 2017-07-07 01:50:12Z dwm $
//===========================================================================
//  Copyright (c) Daniel W. McRobb 2016
//  All rights reserved.
//
//  Redistribution and use in source and binary forms, with or without
//  modification, are permitted provided that the following conditions
//  are met:
//
//  1. Redistributions of source code must retain the above copyright
//     notice, this list of conditions and the following disclaimer.
//  2. Redistributions in binary form must reproduce the above copyright
//     notice, this list of conditions and the following disclaimer in the
//     documentation and/or other materials provided with the distribution.
//  3. The names of the authors and copyright holders may not be used to
//     endorse or promote products derived from this software without
//     specific prior written permission.
//
//  IN NO EVENT SHALL DANIEL W. MCROBB BE LIABLE TO ANY PARTY FOR
//  DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES,
//  INCLUDING LOST PROFITS, ARISING OUT OF THE USE OF THIS SOFTWARE,
//  EVEN IF DANIEL W. MCROBB HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH
//  DAMAGE.
//
//  THE SOFTWARE PROVIDED HEREIN IS ON AN "AS IS" BASIS, AND
//  DANIEL W. MCROBB HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT,
//  UPDATES, ENHANCEMENTS, OR MODIFICATIONS. DANIEL W. MCROBB MAKES NO
//  REPRESENTATIONS AND EXTENDS NO WARRANTIES OF ANY KIND, EITHER
//  IMPLIED OR EXPRESS, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
//  WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE,
//  OR THAT THE USE OF THIS SOFTWARE WILL NOT INFRINGE ANY PATENT,
//  TRADEMARK OR OTHER RIGHTS.
//===========================================================================

//---------------------------------------------------------------------------
//!  \file DwmPiGdoResponseMessage.hh
//!  \brief Dwm::Pi::Gdo::ResponseMessage definition
//!  \author Daniel W. McRobb \link mailto:dwm@mcplex.net \endlink
//---------------------------------------------------------------------------

#ifndef _DWMPIGDORESPONSEMESSAGE_HH_
#define _DWMPIGDORESPONSEMESSAGE_HH_

#include <iostream>
#include <string>

#include <json/json.h>

namespace Dwm {

  namespace Pi {

    namespace Gdo {

      //----------------------------------------------------------------------
      //!  Encapsulates a response message from mcpigdod.
      //----------------------------------------------------------------------
      class ResponseMessage
      {
      public:
        //--------------------------------------------------------------------
        //!  Default constructor.
        //--------------------------------------------------------------------
        ResponseMessage()
            : _value()
        {}
          
        //--------------------------------------------------------------------
        //!  Construct from the given @c value.
        //--------------------------------------------------------------------
        ResponseMessage(const Json::Value & value);
        
        //--------------------------------------------------------------------
        //!  Returns the message contents as JSON.
        //--------------------------------------------------------------------
        const Json::Value & Json() const;

        //--------------------------------------------------------------------
        //!  Set the message contents to @c value.
        //--------------------------------------------------------------------
        const Json::Value & Json(const Json::Value & value);
        
        //--------------------------------------------------------------------
        //!  Reads the message from the given descriptor @c fd and decrypts
        //!  it using the given @c secret.  @c secret must have been
        //!  determined previously using
        //!  Dwm::Auth::PeerAuthenticator::Authenticate from the libDwmAuth
        //!  package.  Returns true on success, false on failure.
        //--------------------------------------------------------------------
        bool Read(int fd, const std::string & secret);

        //--------------------------------------------------------------------
        //!  Reads the message from the given istream @c is and decrypts
        //!  it using the given @c secret.  @c secret must have been
        //!  determined previously using
        //!  Dwm::Auth::PeerAuthenticator::Authenticate from the libDwmAuth
        //!  package.  Returns the istream.
        //--------------------------------------------------------------------
        std::istream & Read(std::istream & is, const std::string & secret);
        
        //--------------------------------------------------------------------
        //!  Encrypts the message with the given @c secret and writes it to
        //!  the given descriptor @c fd.  @c secret must have been determined
        //!  previously using Dwm::Auth::PeerAuthenticator::Authenticate from
        //!  the libDwmAuth package.  Returns true on success, false on
        //!  failure.               
        //--------------------------------------------------------------------
        bool Write(int fd, const std::string & secret) const;

        //--------------------------------------------------------------------
        //!  Encrypts the message with the given @c secret and writes it to
        //!  the given ostream @c os.  @c secret must have been determined
        //!  previously using Dwm::Auth::PeerAuthenticator::Authenticate from
        //!  the libDwmAuth package.  Returns the ostream.
        //--------------------------------------------------------------------
        std::ostream &
        Write(std::ostream & os, const std::string & secret) const;

      protected:
        Json::Value  _value;
      };

    }  // namespace Gdo

  }  // namespace Pi

}  // namespace Dwm

#endif  // _DWMPIGDORESPONSEMESSAGE_HH_
