//===========================================================================
// @(#) $DwmPath: dwm/mcplex/mcpigdocomm/tags/mcpigdocomm-0.1.0/include/DwmPiGdoRequestMessage.hh 9758 $
// @(#) $Id: DwmPiGdoRequestMessage.hh 9758 2017-07-07 01:50:12Z dwm $
//===========================================================================
//  Copyright (c) Daniel W. McRobb 2016
//  All rights reserved.
//
//  Redistribution and use in source and binary forms, with or without
//  modification, are permitted provided that the following conditions
//  are met:
//
//  1. Redistributions of source code must retain the above copyright
//     notice, this list of conditions and the following disclaimer.
//  2. Redistributions in binary form must reproduce the above copyright
//     notice, this list of conditions and the following disclaimer in the
//     documentation and/or other materials provided with the distribution.
//  3. The names of the authors and copyright holders may not be used to
//     endorse or promote products derived from this software without
//     specific prior written permission.
//
//  IN NO EVENT SHALL DANIEL W. MCROBB BE LIABLE TO ANY PARTY FOR
//  DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES,
//  INCLUDING LOST PROFITS, ARISING OUT OF THE USE OF THIS SOFTWARE,
//  EVEN IF DANIEL W. MCROBB HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH
//  DAMAGE.
//
//  THE SOFTWARE PROVIDED HEREIN IS ON AN "AS IS" BASIS, AND
//  DANIEL W. MCROBB HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT,
//  UPDATES, ENHANCEMENTS, OR MODIFICATIONS. DANIEL W. MCROBB MAKES NO
//  REPRESENTATIONS AND EXTENDS NO WARRANTIES OF ANY KIND, EITHER
//  IMPLIED OR EXPRESS, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
//  WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE,
//  OR THAT THE USE OF THIS SOFTWARE WILL NOT INFRINGE ANY PATENT,
//  TRADEMARK OR OTHER RIGHTS.
//===========================================================================

//---------------------------------------------------------------------------
//!  \file DwmPiGdoRequestMessage.hh
//!  \brief Dwm::Pi::Gdo::RequestMessage class definition
//!  \author Daniel W. McRobb \link mailto:dwm@mcplex.net \endlink
//---------------------------------------------------------------------------

#ifndef _DWMPIGDOREQUESTMESSAGE_HH_
#define _DWMPIGDOREQUESTMESSAGE_HH_

#include <string>

#include <json/json.h>

namespace Dwm {

  namespace Pi {

    namespace Gdo {

      //----------------------------------------------------------------------
      //!  Encapsulates a request message to be sent to mcpigdod.
      //----------------------------------------------------------------------
      class RequestMessage
      {
      public:
        //--------------------------------------------------------------------
        //!  Types of requests.
        //--------------------------------------------------------------------
        typedef enum {
          e_requestNone,
          e_requestStatus,
          e_requestOpenDoor,
          e_requestCloseDoor,
          e_requestGetConfig,
          e_requestActivate,
          e_requestGetMcastKey
        } RequestEnum;

        //--------------------------------------------------------------------
        //!  Default constructor
        //--------------------------------------------------------------------
        RequestMessage();
        
        //--------------------------------------------------------------------
        //!  Construct with the given request type @c request and data
        //!  @c requestData.
        //--------------------------------------------------------------------
        RequestMessage(RequestEnum request,
                       const std::string & requestData = "");
        
        //--------------------------------------------------------------------
        //!  Read the request from the given descriptor @c fd and decrypt
        //!  with the given @c secret.  Returns true on success, false on
        //!  failure.  The @c secret must have been negotiated with
        //!  Dwm::Auth::PeerAuthenticator::Authenticate() from the
        //!  libDwmAuth package before calling this function.
        //--------------------------------------------------------------------
        bool Read(int fd, const std::string & secret);
        
        //--------------------------------------------------------------------
        //!  Write the request to the given descriptor @c fd and encrypt
        //!  with the given @c secret.  Returns true on success, false on
        //!  failure.  The @c secret must have been negotiated with
        //!  Dwm::Auth::PeerAuthenticator::Authenticate() from the
        //!  libDwmAuth package before calling this function.
        //--------------------------------------------------------------------
        bool Write(int fd, const std::string & secret) const;
        
        //--------------------------------------------------------------------
        //!  Returns the message in JSON form.
        //--------------------------------------------------------------------
        const Json::Value & Json() const;

      private:
        Json::Value  _value;
      };

    }  // namespace Gdo

  }  // namespace Pi

}  // namespace Dwm

#endif  // _DWMPIGDOREQUESTMESSAGE_HH_
