//===========================================================================
// @(#) $DwmPath: dwm/mcplex/mcpigdocomm/tags/mcpigdocomm-0.1.0/apps/mcpigdowatch/mcpigdowatch.cc 9753 $
// @(#) $Id: mcpigdowatch.cc 9753 2017-07-07 00:21:41Z dwm $
//===========================================================================
//  Copyright (c) Daniel W. McRobb 2016
//  All rights reserved.
//
//  Redistribution and use in source and binary forms, with or without
//  modification, are permitted provided that the following conditions
//  are met:
//
//  1. Redistributions of source code must retain the above copyright
//     notice, this list of conditions and the following disclaimer.
//  2. Redistributions in binary form must reproduce the above copyright
//     notice, this list of conditions and the following disclaimer in the
//     documentation and/or other materials provided with the distribution.
//  3. The names of the authors and copyright holders may not be used to
//     endorse or promote products derived from this software without
//     specific prior written permission.
//
//  IN NO EVENT SHALL DANIEL W. MCROBB BE LIABLE TO ANY PARTY FOR
//  DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES,
//  INCLUDING LOST PROFITS, ARISING OUT OF THE USE OF THIS SOFTWARE,
//  EVEN IF DANIEL W. MCROBB HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH
//  DAMAGE.
//
//  THE SOFTWARE PROVIDED HEREIN IS ON AN "AS IS" BASIS, AND
//  DANIEL W. MCROBB HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT,
//  UPDATES, ENHANCEMENTS, OR MODIFICATIONS. DANIEL W. MCROBB MAKES NO
//  REPRESENTATIONS AND EXTENDS NO WARRANTIES OF ANY KIND, EITHER
//  IMPLIED OR EXPRESS, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
//  WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE,
//  OR THAT THE USE OF THIS SOFTWARE WILL NOT INFRINGE ANY PATENT,
//  TRADEMARK OR OTHER RIGHTS.
//===========================================================================

//---------------------------------------------------------------------------
//!  \file mcpigdowatch.cc
//!  \brief NOT YET DOCUMENTED
//---------------------------------------------------------------------------

extern "C" {
  #include <sys/types.h>
  #include <sys/socket.h>
  #include <netinet/in.h>
  #include <netinet/tcp.h>
  #include <arpa/inet.h>
  #include <netdb.h>
  #include <pwd.h>
  #include <unistd.h>
}

#include <regex>
#include <utility>

#include <cryptopp/base64.h>
#include <json/json.h>

#include "DwmIO.hh"
#include "DwmIpv4Prefix.hh"
#include "DwmOptArgs.hh"
#include "DwmSocket.hh"
#include "DwmSvnTag.hh"
#include "DwmSysLogger.hh"
#include "DwmAuth.hh"
#include "DwmPiGdoRequestMessage.hh"
#include "DwmPiGdoResponseMessage.hh"
#include "DwmAuthSymCryptoMessage.hh"
#include "DwmAuthPeerAuthenticator.hh"

static const Dwm::SvnTag svntag("@(#) $DwmPath: dwm/mcplex/mcpigdocomm/tags/mcpigdocomm-0.1.0/apps/mcpigdowatch/mcpigdowatch.cc 9753 $");

using namespace std;
using namespace Dwm;
using namespace Dwm::Pi;

//----------------------------------------------------------------------------
//!  
//----------------------------------------------------------------------------
static bool Authenticate(Dwm::Socket & s, string & agreedKey)
{
  bool  rc = false;
  Auth::PeerAuthenticator  peerAuth("", "");
  string theirId;
  return peerAuth.Authenticate(s, theirId, agreedKey);
}

//----------------------------------------------------------------------------
//!  
//----------------------------------------------------------------------------
Json::Value RequestResponse(Socket & s, const string & agreedKey,
                            const Gdo::RequestMessage & request)
{
  Json::Value           rc;
  Gdo::ResponseMessage  response;
  Json::FastWriter      jfw;
  if (request.Write(s, agreedKey)) {
    if (response.Read(s, agreedKey)) {
      rc = response.Json();
    }
    else {
      Syslog(LOG_ERR, "Failed to read server response");
    }
  }
  else {
    Syslog(LOG_ERR, "Failed to write server request");
  }
  return rc;
}

//----------------------------------------------------------------------------
//!  
//----------------------------------------------------------------------------
bool Connect(const string & host, uint16_t port, Socket & s)
{
  bool  rc = false;
  struct hostent  *hostEntry = gethostbyname(host.c_str());
  if (! hostEntry) {
    cerr << "Host '" << host << "' not found.\n";
    exit(1);
  }
  
  if (s.Open(PF_INET, SOCK_STREAM, 0)) {
    struct sockaddr_in  servAddr;
    memset(&servAddr, 0, sizeof(servAddr));
    servAddr.sin_len = sizeof(servAddr);
    servAddr.sin_family = AF_INET;
    servAddr.sin_port = htons(port);
    servAddr.sin_addr.s_addr = *(in_addr_t *)hostEntry->h_addr_list[0];
    if (s.Connect(servAddr)) {
      int  noDelay = 1;
      s.Setsockopt(IPPROTO_TCP, TCP_NODELAY, &noDelay, sizeof(noDelay));
      rc = true;
    }
  }
  return rc;
}

//----------------------------------------------------------------------------
//!  
//----------------------------------------------------------------------------
static string GetMcastKey(const string & host, uint16_t port)
{
  using CryptoPP::Base64Decoder;
  using CryptoPP::StringSink;
  using CryptoPP::StringSource;

  string  rc;
  Socket  s;
  string  agreedKey;
  if (Connect(host, port, s)) {
    if (Authenticate(s, agreedKey)) {
      Gdo::RequestMessage  request(Gdo::RequestMessage::e_requestGetMcastKey);
      Json::Value  resp = RequestResponse(s, agreedKey, request);
      if (! resp.empty()) {
        StringSource  ss((const byte *)resp["mcastKey"].asString().c_str(),
                         resp["mcastKey"].asString().size(), true,
                         new Base64Decoder(new StringSink(rc)));
      }
    }
    s.Close();
  }
  
  return rc;
}

//----------------------------------------------------------------------------
//!  
//----------------------------------------------------------------------------
static void Usage(const string & argv0)
{
  cerr << "Usage: " << argv0 << " [-h host] status hostname\n"
       << "       " << argv0 << " [-h host] config hostname\n";
  return;
}

//----------------------------------------------------------------------------
//!  
//----------------------------------------------------------------------------
static pair<Ipv4Address,uint16_t> GetMulticastAddrPort(const string & s)
{
  pair<Ipv4Address,uint16_t>  rc(Ipv4Address("0.0.0.0"), 0);
  regex   rgx("([0-9]+\\.[0-9]+\\.[0-9]+\\.[0-9]+)[:]([0-9]+)",
              regex::ECMAScript|regex::optimize);
  smatch  sm;
  if (regex_search(s, sm, rgx)) {
    if (sm.size() == 3) {
      Ipv4Address  addr(sm[1].str());
      uint32_t     port = stoul(sm[2].str());
      if (Ipv4Prefix("224.0.0.0/4").Contains(addr)
          && (port <= 65535)) {
        rc.first = addr;
        rc.second = port;
      }
    }
  }
  return rc;
}

//----------------------------------------------------------------------------
//!  
//----------------------------------------------------------------------------
int main(int argc, char *argv[])
{
  OptArgs  optargs;
  optargs.AddOptArg("g:", "group", false, "224.0.0.42:2121",
                    "multicast address:port");
  optargs.AddOptArg("h:", "host", false, "", "mcpigdod host");
  optargs.AddOptArg("p:", "port", false, "2121", "mcpigdod TCP port");
  int  nextArg = optargs.Parse(argc, argv);

  string  host;
  if (getenv("MCPIGDODHOST")) {
    host = getenv("MCPIGDODHOST");
  }
  if (! optargs.Get<string>('h').empty()) {
    host = optargs.Get<string>('h');
  }
  if (host.empty()) {
    optargs.Usage(argv[0]);
    cerr << "The MCPIGDODHOST environment variable may be used in place of\n"
         << "the [-h host] argument.\n";
    exit(1);
  }
  string  mcastKey = GetMcastKey(host, stoul(optargs.Get<string>('p')));
  if (! mcastKey.empty()) {
    Socket  s;
    if (s.Open(PF_INET, SOCK_DGRAM, IPPROTO_UDP)) {
      int  on = 1;
      s.Setsockopt(SOL_SOCKET, SO_REUSEPORT, &on, sizeof(on));
      pair<Ipv4Address,uint16_t>  mcastAddrPort =
        GetMulticastAddrPort(optargs.Get<string>('g'));
      if (mcastAddrPort.first != Ipv4Address("0.0.0.0")) {
        if (s.Bind(Ipv4Address(INADDR_ANY), mcastAddrPort.second)) {
          if (s.JoinMulticastGroup(mcastAddrPort.first,
                                   Ipv4Address(INADDR_ANY))) {
            for (;;) {
              Auth::SymCrypto::Message  msg(mcastKey);
              Ipv4Address  srcAddr;
              uint16_t     srcPort;
              if (msg.RecvFrom(s, 0, srcAddr, srcPort) > 0) {
                Json::Reader  reader;
                Json::Value   value;
                if (reader.parse(msg.Value(), value)) {
                  cout << value << '\n';
                }
              }
            }
          }
        }
      }
      else {
        cerr << "Bad multicast group " << optargs.Get<string>('g') << endl;
        optargs.Usage(argv[0]);
        exit(1);
      }
    }
  }
  else {
    cerr << "Failed to retrieve multicast encryption key\n";
    exit(1);
  }
}
